/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http.auth;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;

public class DigestServer
extends AbstractBusTestServerBase {
    public static final String PORT = DigestServer.allocatePort(DigestServer.class);
    private Server server;

    protected void configureServer() throws Exception {
        URL resource = ((Object)((Object)this)).getClass().getResource("jetty-realm.properties");
        HashLoginService realm = new HashLoginService("BookStoreRealm", resource.toString());
        this.server.addBean((Object)realm);
    }

    protected void run() {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(Integer.parseInt(PORT));
        this.server.setConnectors(new Connector[]{connector});
        WebAppContext webappcontext = new WebAppContext();
        webappcontext.setContextPath("/digestauth");
        String warPath = null;
        try {
            URL res = ((Object)((Object)this)).getClass().getResource("/digestauth");
            warPath = res.toURI().getPath();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        webappcontext.setWar(warPath);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{webappcontext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        try {
            this.configureServer();
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DigestServer s = new DigestServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

