/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty;

import java.net.URL;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.http_jetty.GreeterImpl;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class JettyBasicAuthServer
extends AbstractBusTestServerBase {
    static final String PORT = JettyBasicAuthServer.allocatePort(JettyBasicAuthServer.class);
    static final String ADDRESS = "http://localhost:" + PORT + "/SoapContext/SoapPort";
    Endpoint ep;

    protected void run() {
        String configurationFile = "jettyBasicAuthServer.xml";
        URL configure = JettyBasicAuthServer.class.getResource(configurationFile);
        Bus bus = new SpringBusFactory().createBus(configure, true);
        bus.getInInterceptors().add(new LoggingInInterceptor());
        bus.getOutInterceptors().add(new LoggingOutInterceptor());
        SpringBusFactory.setDefaultBus((Bus)bus);
        this.setBus(bus);
        GreeterImpl implementor = new GreeterImpl();
        this.ep = Endpoint.publish((String)ADDRESS, (Object)implementor);
    }

    public void tearDown() throws Exception {
        if (this.ep != null) {
            this.ep.stop();
            this.ep = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            JettyBasicAuthServer s = new JettyBasicAuthServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

