/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.http_jetty.JettyBasicAuthServer;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JettyBasicAuthTest
extends AbstractClientServerTestBase {
    private static final String ADDRESS = JettyBasicAuthServer.ADDRESS;
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceAddressing");
    private Greeter greeter;

    @BeforeClass
    public static void startServers() throws Exception {
        JettyBasicAuthTest.assertTrue((String)"server did not launch correctly", (boolean)JettyBasicAuthTest.launchServer(JettyBasicAuthServer.class, (boolean)true));
    }

    @Before
    public void setUp() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        this.greeter = (Greeter)new SOAPService(wsdl, SERVICE_NAME).getPort(Greeter.class);
        BindingProvider bp = (BindingProvider)this.greeter;
        ClientProxy.getClient((Object)this.greeter).getInInterceptors().add(new LoggingInInterceptor());
        ClientProxy.getClient((Object)this.greeter).getOutInterceptors().add(new LoggingOutInterceptor());
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", ADDRESS);
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", "ffang");
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", "pswd");
    }

    @Test
    public void testBasicAuth() throws Exception {
        JettyBasicAuthTest.assertEquals((Object)"Hello Alice", (Object)this.greeter.greetMe("Alice"));
    }
}

