/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.systest.http_jetty.Server;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.SOAPService;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThreadPoolTest
extends AbstractClientServerTestBase {
    private static final String ADDRESS = Server.ADDRESS;
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceAddressing");
    private Greeter greeter;

    @BeforeClass
    public static void startServers() throws Exception {
        int threads = Math.max(1, (Runtime.getRuntime().availableProcessors() + 3) / 4) * 2 + 3;
        System.setProperty("ThreadPoolTest.threads", Integer.toString(threads));
        ThreadPoolTest.assertTrue((String)"server did not launch correctly", (boolean)ThreadPoolTest.launchServer(Server.class, (boolean)true));
    }

    @Before
    public void setUp() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        this.greeter = (Greeter)new SOAPService(wsdl, SERVICE_NAME).getPort(Greeter.class);
        BindingProvider bp = (BindingProvider)this.greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", ADDRESS);
    }

    @Test
    public void testFallbackThreadPoolConfig() throws Exception {
        TestRunnable[] r = new TestRunnable[5];
        Thread[] invokers = new Thread[5];
        for (int i = 0; i < invokers.length; ++i) {
            r[i] = new TestRunnable(i);
            invokers[i] = new Thread(r[i]);
            invokers[i].setDaemon(true);
            invokers[i].start();
        }
        int countLess = 0;
        int countMore = 0;
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i].join(6000L);
            if (r[i].getTotal() > 3000L) {
                ++countMore;
                continue;
            }
            ++countLess;
        }
        ThreadPoolTest.assertEquals((long)3L, (long)countLess);
        ThreadPoolTest.assertEquals((long)2L, (long)countMore);
    }

    class TestRunnable
    implements Runnable {
        int i;
        long total;

        public TestRunnable(int i) {
            this.i = i;
        }

        public void run() {
            long start = System.currentTimeMillis();
            try {
                ThreadPoolTest.this.greeter.greetMeLater(2000L);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            long end = System.currentTimeMillis();
            this.total = end - start;
        }

        public long getTotal() {
            return this.total;
        }
    }
}

