/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http_jetty.continuations;

import java.util.concurrent.CountDownLatch;
import org.apache.cxf.systest.http_jetty.continuations.HelloContinuation;
import org.junit.Assert;

public class ControlWorker
implements Runnable {
    private HelloContinuation helloPort;
    private String firstName;
    private CountDownLatch startSignal;
    private CountDownLatch resumeSignal;

    public ControlWorker(HelloContinuation helloPort, String firstName, CountDownLatch startSignal, CountDownLatch resumeSignal) {
        this.helloPort = helloPort;
        this.firstName = firstName;
        this.startSignal = startSignal;
        this.resumeSignal = resumeSignal;
    }

    public void run() {
        try {
            this.startSignal.await();
            if (!this.helloPort.isRequestSuspended(this.firstName)) {
                Assert.fail((String)("No suspended invocation for " + this.firstName));
            }
            this.helloPort.resumeRequest(this.firstName);
            this.resumeSignal.countDown();
        }
        catch (InterruptedException ex) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            Assert.fail((String)("Control thread for " + this.firstName + " failed"));
        }
    }
}

