/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.local_transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.local_transport.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectDispatchClientTest
extends AbstractBusClientServerTestBase {
    private static Bus staticBus;
    private final QName serviceName = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private final QName localPortName = new QName("http://apache.org/hello_world_soap_http", "localPortName");

    @BeforeClass
    public static void startServers() throws Exception {
        staticBus = BusFactory.getDefaultBus();
        BusFactory.setThreadDefaultBus((Bus)staticBus);
        DirectDispatchClientTest.assertTrue((String)"server did not launch correctly", (boolean)DirectDispatchClientTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testDirectDispatch() {
        this.invokeService(true);
    }

    @Test
    public void testPipeLineDispatch() {
        this.invokeService(false);
    }

    private void invokeService(boolean isDirectDispatch) {
        BusFactory.setThreadDefaultBus((Bus)staticBus);
        Service service = Service.create((QName)this.serviceName);
        service.addPort(this.localPortName, "http://schemas.xmlsoap.org/soap/", "local://Greeter");
        Greeter greeter = (Greeter)service.getPort(this.localPortName, Greeter.class);
        if (isDirectDispatch) {
            Client client = ClientProxy.getClient((Object)greeter);
            client.getOutInterceptors().add(new GZIPOutInterceptor(50));
            client.getInInterceptors().add(new GZIPInInterceptor());
            InvocationHandler handler = Proxy.getInvocationHandler(greeter);
            BindingProvider bp = null;
            if (handler instanceof BindingProvider) {
                bp = (BindingProvider)handler;
                Map requestContext = bp.getRequestContext();
                requestContext.put(LocalConduit.DIRECT_DISPATCH, true);
            }
        }
        String reply = greeter.greetMe("test");
        DirectDispatchClientTest.assertEquals((Object)"Hello test", (Object)reply);
        reply = greeter.sayHi();
        DirectDispatchClientTest.assertNotNull((String)"no response received from service", (Object)reply);
        DirectDispatchClientTest.assertEquals((Object)"Bonjour", (Object)reply);
    }
}

