/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.multitransport;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.testutil.common.EmbeddedJMSBrokerLauncher;
import org.apache.hello_world_doc_lit.Greeter;
import org.apache.hello_world_doc_lit.HTTPGreeterImpl;
import org.apache.hello_world_doc_lit.JMSGreeterImpl;
import org.apache.hello_world_doc_lit.MultiTransportService;
import org.apache.hello_world_doc_lit.PingMeFault;
import org.junit.BeforeClass;
import org.junit.Test;

public class MultiTransportClientServerTest
extends AbstractBusClientServerTestBase {
    static final String JMS_PORT = EmbeddedJMSBrokerLauncher.PORT;
    static final String PORT = MultiTransportClientServerTest.allocatePort(MyServer.class);
    static final Logger LOG = LogUtils.getLogger(MultiTransportClientServerTest.class);
    private final QName serviceName = new QName("http://apache.org/hello_world_doc_lit", "MultiTransportService");

    @BeforeClass
    public static void startServers() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        if (System.getProperty("org.apache.activemq.default.directory.prefix") != null) {
            props.put("org.apache.activemq.default.directory.prefix", System.getProperty("org.apache.activemq.default.directory.prefix"));
        }
        MultiTransportClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MultiTransportClientServerTest.launchServer(EmbeddedJMSBrokerLauncher.class, props, null));
        MultiTransportClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)MultiTransportClientServerTest.launchServer(MyServer.class, (boolean)true));
    }

    @Test
    public void testMultiTransportInOneService() throws Exception {
        QName portName1 = new QName("http://apache.org/hello_world_doc_lit", "HttpPort");
        QName portName2 = new QName("http://apache.org/hello_world_doc_lit", "JMSPort");
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world_doc_lit.wsdl");
        MultiTransportClientServerTest.assertNotNull((Object)wsdl);
        String wsdlString = wsdl.toString();
        MultiTransportService service = new MultiTransportService(wsdl, this.serviceName);
        MultiTransportClientServerTest.assertNotNull((Object)service);
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors((Bus)this.getBus(), (String)wsdlString);
        String response1 = new String("Hello Milestone-");
        String response2 = new String("Bonjour");
        try {
            String reply;
            String exResponse;
            String greeting;
            int idx;
            Greeter greeter = (Greeter)service.getPort(portName1, Greeter.class);
            this.updateAddressPort(greeter, PORT);
            for (idx = 0; idx < 5; ++idx) {
                greeting = greeter.greetMe("Milestone-" + idx);
                MultiTransportClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                exResponse = response1 + idx;
                MultiTransportClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                reply = greeter.sayHi();
                MultiTransportClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                MultiTransportClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.pingMe();
                    MultiTransportClientServerTest.fail((String)"Should have thrown FaultException");
                    continue;
                }
                catch (PingMeFault ex) {
                    MultiTransportClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
            }
            greeter = null;
            greeter = (Greeter)service.getPort(portName2, Greeter.class);
            for (idx = 0; idx < 5; ++idx) {
                greeting = greeter.greetMe("Milestone-" + idx);
                MultiTransportClientServerTest.assertNotNull((String)"no response received from service", (Object)greeting);
                exResponse = response1 + idx;
                MultiTransportClientServerTest.assertEquals((Object)exResponse, (Object)greeting);
                reply = greeter.sayHi();
                MultiTransportClientServerTest.assertNotNull((String)"no response received from service", (Object)reply);
                MultiTransportClientServerTest.assertEquals((Object)response2, (Object)reply);
                try {
                    greeter.pingMe();
                    MultiTransportClientServerTest.fail((String)"Should have thrown FaultException");
                    continue;
                }
                catch (PingMeFault ex) {
                    MultiTransportClientServerTest.assertNotNull((Object)ex.getFaultInfo());
                }
            }
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public static class MyServer
    extends AbstractBusTestServerBase {
        Definition def;
        Endpoint ep1;
        Endpoint ep2;

        protected void run() {
            HTTPGreeterImpl implementor = new HTTPGreeterImpl();
            String address = "http://localhost:" + PORT + "/SOAPDocLitService/SoapPort";
            this.ep1 = Endpoint.publish((String)address, (Object)implementor);
            EmbeddedJMSBrokerLauncher.updateWsdlExtensors((Bus)this.getBus(), (String)"testutils/hello_world_doc_lit.wsdl");
            implementor = new JMSGreeterImpl();
            this.ep2 = Endpoint.publish(null, (Object)implementor);
        }

        public void tearDown() {
            if (this.ep1 != null) {
                this.ep1.stop();
            }
            if (this.ep2 != null) {
                this.ep2.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                MyServer s = new MyServer();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                LOG.info("done!");
            }
        }
    }
}

