/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebRequest;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.cxf.test.AbstractCXFTest;
import org.junit.After;
import org.junit.Before;
import org.xml.sax.SAXException;

public abstract class AbstractServletTest
extends AbstractCXFTest {
    public static final String CONTEXT = "/mycontext";
    public static final String CONTEXT_URL = "http://localhost/mycontext";
    protected ServletRunner sr;

    @Before
    public void setUp() throws Exception {
        InputStream configurationStream = this.getResourceAsStream(this.getConfiguration());
        this.sr = new ServletRunner(configurationStream, CONTEXT);
        try {
            this.sr.newClient().getResponse("http://localhost/mycontext/services");
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    @After
    public void tearDown() throws Exception {
        if (this.sr != null) {
            this.sr.shutDown();
        }
    }

    protected String getConfiguration() {
        return "/org/apache/cxf/systest/servlet/web.xml";
    }

    protected ServletUnitClient newClient() {
        return this.sr.newClient();
    }

    protected void expectErrorCode(WebRequest request, int errorCode, String errorText) throws MalformedURLException, IOException, SAXException {
        String failureText = "Expected error " + errorCode + " from " + request.getURL();
        try {
            this.newClient().getResponse(request);
            AbstractServletTest.fail((String)(errorText + " -got success instead"));
        }
        catch (HttpException e) {
            AbstractServletTest.assertEquals((String)failureText, (long)errorCode, (long)e.getResponseCode());
        }
    }
}

