/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import java.util.HashSet;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.apache.cxf.systest.servlet.GetMethodQueryWebRequest;
import org.apache.hello_world_soap_http.BaseGreeterImpl;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class CXFServletTest
extends AbstractServletTest {
    @Before
    public void setUp() throws Exception {
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
        super.setUp();
    }

    protected Bus createBus() throws BusException {
        return null;
    }

    @Test
    public void testPostInvokeServices() throws Exception {
        this.invoke("UTF-8");
        this.invoke("iso-8859-1");
    }

    private void invoke(String encoding) throws Exception {
        PostMethodWebRequest req = new PostMethodWebRequest("http://localhost/mycontext/services/greeter", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=" + encoding);
        ServletUnitClient client = this.newClient();
        WebResponse response = client.getResponse((WebRequest)req);
        client.setExceptionsThrownOnErrorStatus(false);
        CXFServletTest.assertEquals((Object)"text/xml", (Object)response.getContentType());
        CXFServletTest.assertTrue((boolean)encoding.equalsIgnoreCase(response.getCharacterSet()));
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:sayHiResponse", doc);
    }

    @Test
    public void testGetServiceList() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services");
        WebLink[] links = res.getLinks();
        CXFServletTest.assertEquals((String)"Wrong number of service links", (long)4L, (long)links.length);
        HashSet<String> links2 = new HashSet<String>();
        for (WebLink l : links) {
            links2.add(l.getURLString());
        }
        CXFServletTest.assertTrue((boolean)links2.contains("http://localhost/mycontext/services/greeter?wsdl"));
        CXFServletTest.assertTrue((boolean)links2.contains("http://localhost/mycontext/services/greeter2?wsdl"));
        CXFServletTest.assertTrue((boolean)links2.contains("http://cxf.apache.org/MyGreeter?wsdl"));
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
        res = client.getResponse("http://localhost/mycontext/services/");
        links = res.getLinks();
        links2.clear();
        for (WebLink l : links) {
            links2.add(l.getURLString());
        }
        CXFServletTest.assertEquals((String)"Wrong number of service links", (long)4L, (long)links.length);
        CXFServletTest.assertTrue((boolean)links2.contains("http://localhost/mycontext/services/greeter?wsdl"));
        CXFServletTest.assertTrue((boolean)links2.contains("http://localhost/mycontext/services/greeter2?wsdl"));
        CXFServletTest.assertTrue((boolean)links2.contains("http://cxf.apache.org/MyGreeter?wsdl"));
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
        CXFServletTest.assertNotNull((Object)BusFactory.getDefaultBus((boolean)false));
    }

    @Test
    public void testGetUnformatServiceList() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services?formatted=false");
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter3"));
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter2"));
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter"));
    }

    @Test
    public void testServiceListWithLoopAddress() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services");
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter3"));
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter2"));
        CXFServletTest.assertTrue((boolean)res.getText().contains("http://localhost/mycontext/services/greeter"));
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl");
        res = client.getResponse((WebRequest)req);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter2?wsdl");
        res = client.getResponse((WebRequest)req);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter3?wsdl");
        res = client.getResponse((WebRequest)req);
        String loopAddr = "http://127.0.0.1/mycontext";
        res = client.getResponse(loopAddr + "/services");
        CXFServletTest.assertFalse((boolean)res.getText().contains("http://127.0.0.1/mycontext/serviceshttp://localhost/mycontext/services/greeter"));
    }

    @Test
    public void testGetWSDL() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        Document doc = DOMUtils.readXml((InputStream)res.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://localhost/mycontext/services/greeter']", doc);
    }

    @Test
    public void testGetWSDLWithIncludes() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter3?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        Document doc = DOMUtils.readXml((InputStream)res.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.assertXPathEquals("//xsd:include/@schemaLocation", "http://localhost/mycontext/services/greeter3?xsd=hello_world_includes2.xsd", doc.getDocumentElement());
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter3?xsd=hello_world_includes2.xsd");
        res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        doc = DOMUtils.readXml((InputStream)res.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.assertValid("//xsd:complexType[@name='ErrorCode']", doc);
    }

    @Test
    public void testGetWSDLWithXMLBinding() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter2?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        Document doc = DOMUtils.readXml((InputStream)res.getInputStream());
        CXFServletTest.assertNotNull((Object)doc);
        this.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//http:address[@location='http://localhost/mycontext/services/greeter2']", doc);
    }

    @Test
    public void testInvalidServiceUrl() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/services/NoSuchService");
        CXFServletTest.assertEquals((long)404L, (long)res.getResponseCode());
        CXFServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
    }

    @Test
    public void testServiceWsdlNotFound() throws Exception {
        GetMethodWebRequest req = new GetMethodWebRequest("http://localhost/mycontext/services/NoSuchService?wsdl");
        this.expectErrorCode((WebRequest)req, 404, "Response code 404 required for invalid WSDL url.");
    }

    @Test
    public void testGetImportedXSD() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        String text = res.getText();
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((boolean)text.contains("http://localhost/mycontext/services/greeter?wsdl=test_import.xsd"));
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/greeter?wsdl=test_import.xsd");
        res = client.getResponse((WebRequest)req);
        CXFServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        text = res.getText();
        CXFServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        CXFServletTest.assertTrue((String)"the xsd should contain the completType SimpleStruct", (boolean)text.contains("<complexType name=\"SimpleStruct\">"));
    }

    @Test
    public void testGetBinding() throws Exception {
        Endpoint ep = Endpoint.create((String)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)new HelloImpl());
        CXFServletTest.assertTrue((boolean)(ep.getBinding() instanceof SOAPBinding));
    }

    @WebService(serviceName="SOAPService", portName="SoapPort", endpointInterface="org.apache.hello_world_soap_http.Greeter", targetNamespace="http://apache.org/hello_world_soap_http")
    public static class NoWsdlGreeter
    extends BaseGreeterImpl {
    }

    @WebService(name="Hello", portName="HelloPort", serviceName="HelloService", targetNamespace="http://cxf.apache.org/hello")
    public static class HelloImpl {
        public String hello(String name) {
            return "Hello " + name;
        }
    }
}

