/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.junit.Test;
import org.w3c.dom.Document;

public class ExternalServicesServletTest
extends AbstractServletTest {
    static final String FORCED_BASE_ADDRESS = "http://localhost/somewhere";

    protected Bus createBus() throws BusException {
        return null;
    }

    protected String getConfiguration() {
        return "/org/apache/cxf/systest/servlet/web-external.xml";
    }

    @Test
    public void testGetServiceList() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(false);
        WebResponse res = client.getResponse("http://localhost/mycontext/");
        WebLink[] links = res.getLinks();
        ExternalServicesServletTest.assertEquals((String)"Wrong number of service links", (long)4L, (long)links.length);
        HashSet<String> links2 = new HashSet<String>();
        for (WebLink l : links) {
            links2.add(l.getURLString());
        }
        ExternalServicesServletTest.assertTrue((boolean)links2.contains("http://localhost/somewhere/greeter?wsdl"));
        ExternalServicesServletTest.assertTrue((boolean)links2.contains("http://localhost/somewhere/greeter2?wsdl"));
        ExternalServicesServletTest.assertEquals((Object)"text/html", (Object)res.getContentType());
    }

    @Test
    public void testPostInvokeServices() throws Exception {
        this.newClient();
        PostMethodWebRequest req = new PostMethodWebRequest("http://localhost/mycontext/greeter", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=UTF-8");
        WebResponse response = this.newClient().getResponse((WebRequest)req);
        ExternalServicesServletTest.assertEquals((Object)"text/xml", (Object)response.getContentType());
        ExternalServicesServletTest.assertEquals((Object)"UTF-8", (Object)response.getCharacterSet());
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        ExternalServicesServletTest.assertNotNull((Object)doc);
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:sayHiResponse", doc);
    }
}

