/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import javax.servlet.Servlet;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.systest.servlet.HelloImpl;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class NoSpringServletServer
extends AbstractBusTestServerBase {
    public static final String PORT = NoSpringServletServer.allocatePort(NoSpringServletServer.class);
    Server httpServer;

    protected void run() {
        String busFactory = System.getProperty("org.apache.cxf.bus.factory");
        System.setProperty("org.apache.cxf.bus.factory", "org.apache.cxf.bus.CXFBusFactory");
        try {
            this.httpServer = new Server(Integer.parseInt(PORT));
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            this.httpServer.setHandler((Handler)contexts);
            ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
            Bus bus = BusFactory.getDefaultBus((boolean)true);
            CXFServlet cxf = new CXFServlet();
            cxf.setBus(bus);
            ServletHolder servlet = new ServletHolder((Servlet)cxf);
            servlet.setName("soap");
            servlet.setForcedPath("soap");
            root.addServlet(servlet, "/soap/*");
            this.httpServer.start();
            this.setBus(bus);
            BusFactory.setDefaultBus((Bus)bus);
            GreeterImpl impl = new GreeterImpl();
            Endpoint.publish((String)"/Greeter", (Object)impl);
            HelloImpl helloImpl = new HelloImpl();
            Endpoint.publish((String)"/Hello", (Object)helloImpl);
            ((EndpointImpl)Endpoint.create((Object)helloImpl)).publish("/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (busFactory != null) {
                System.setProperty("org.apache.cxf.bus.factory", busFactory);
            } else {
                System.clearProperty("org.apache.cxf.bus.factory");
            }
        }
    }

    public void tearDown() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            NoSpringServletServer s = new NoSpringServletServer();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

