/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.apache.cxf.systest.servlet.GetMethodQueryWebRequest;
import org.junit.Test;
import org.w3c.dom.Document;

public class SpringAutoPublishServletTest
extends AbstractServletTest {
    protected String getConfiguration() {
        return "/org/apache/cxf/systest/servlet/web-spring-auto-launch.xml";
    }

    protected Bus createBus() throws BusException {
        return null;
    }

    @Test
    public void testInvokingSpringBeans() throws Exception {
        PostMethodWebRequest req = new PostMethodWebRequest("http://localhost/mycontext/services/SOAPService", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=utf-8");
        this.invokingEndpoint((WebRequest)req);
        req = new PostMethodWebRequest("http://localhost/mycontext/services/DerivedGreeterService", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=utf-8");
        this.invokingEndpoint((WebRequest)req);
    }

    public void invokingEndpoint(WebRequest req) throws Exception {
        WebResponse response = this.newClient().getResponse(req);
        SpringAutoPublishServletTest.assertEquals((Object)"text/xml", (Object)response.getContentType());
        SpringAutoPublishServletTest.assertTrue((boolean)"utf-8".equalsIgnoreCase(response.getCharacterSet()));
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        SpringAutoPublishServletTest.assertNotNull((Object)doc);
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:sayHiResponse", doc);
    }

    @Test
    public void testGreetMeGetRequest() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/SOAPService/greetMe?requestType=hello");
        WebResponse response = client.getResponse((WebRequest)req);
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:greetMeResponse", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/DerivedGreeterService/greetMe?requestType=hello");
        response = client.getResponse((WebRequest)req);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:greetMeResponse", doc);
    }

    @Test
    public void testGetWSDL() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/SOAPService?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        SpringAutoPublishServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        SpringAutoPublishServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        Document doc = DOMUtils.readXml((InputStream)res.getInputStream());
        SpringAutoPublishServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://localhost/mycontext/services/SOAPService']", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/DerivedGreeterService?wsdl");
        res = client.getResponse((WebRequest)req);
        SpringAutoPublishServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        SpringAutoPublishServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        doc = DOMUtils.readXml((InputStream)res.getInputStream());
        SpringAutoPublishServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://localhost/mycontext/services/DerivedGreeterService']", doc);
    }
}

