/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.servlet;

import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.servlet.AbstractServletTest;
import org.apache.cxf.systest.servlet.GetMethodQueryWebRequest;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.junit.Test;
import org.w3c.dom.Document;

public class SpringServletTest
extends AbstractServletTest {
    protected String getConfiguration() {
        return "/org/apache/cxf/systest/servlet/web-spring.xml";
    }

    protected Bus createBus() throws BusException {
        return null;
    }

    @Test
    public void testInvokingSpringBeans() throws Exception {
        PostMethodWebRequest req = new PostMethodWebRequest("http://localhost/mycontext/services/Greeter", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=utf-8");
        this.invokingEndpoint((WebRequest)req);
        req = new PostMethodWebRequest("http://localhost/mycontext/services/Greeter1", ((Object)((Object)this)).getClass().getResourceAsStream("GreeterMessage.xml"), "text/xml; charset=utf-8");
        this.invokingEndpoint((WebRequest)req);
    }

    public void invokingEndpoint(WebRequest req) throws Exception {
        WebResponse response = this.newClient().getResponse(req);
        SpringServletTest.assertEquals((Object)"text/xml", (Object)response.getContentType());
        SpringServletTest.assertTrue((boolean)"utf-8".equalsIgnoreCase(response.getCharacterSet()));
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        SpringServletTest.assertNotNull((Object)doc);
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:sayHiResponse", doc);
    }

    @Test
    public void testGreetMeGetRequest() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/Greeter/greetMe?requestType=hello");
        WebResponse response = client.getResponse((WebRequest)req);
        Document doc = DOMUtils.readXml((InputStream)response.getInputStream());
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:greetMeResponse", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/Greeter1/greetMe?requestType=hello");
        response = client.getResponse((WebRequest)req);
        doc = DOMUtils.readXml((InputStream)response.getInputStream());
        this.addNamespace("h", "http://apache.org/hello_world_soap_http/types");
        this.assertValid("/s:Envelope/s:Body", doc);
        this.assertValid("//h:greetMeResponse", doc);
    }

    @Test
    public void testGetWSDL() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/Greeter?wsdl");
        WebResponse res = client.getResponse((WebRequest)req);
        SpringServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        SpringServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        Document doc = DOMUtils.readXml((InputStream)res.getInputStream());
        SpringServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://localhost/mycontext/services/Greeter']", doc);
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/Greeter2?wsdl");
        res = client.getResponse((WebRequest)req);
        SpringServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        SpringServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        doc = DOMUtils.readXml((InputStream)res.getInputStream());
        SpringServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://cxf.apache.org/Greeter']", doc);
        Endpoint.publish((String)"/services/Greeter3", (Object)new GreeterImpl());
        req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/Greeter3?wsdl");
        res = client.getResponse((WebRequest)req);
        SpringServletTest.assertEquals((long)200L, (long)res.getResponseCode());
        SpringServletTest.assertEquals((Object)"text/xml", (Object)res.getContentType());
        doc = DOMUtils.readXml((InputStream)res.getInputStream());
        SpringServletTest.assertNotNull((Object)doc);
        this.assertValid("//wsdl:operation[@name='greetMe']", doc);
        this.assertValid("//wsdlsoap:address[@location='http://localhost/mycontext/services/Greeter3']", doc);
    }

    @Test
    public void testIgnoreServiceList() throws Exception {
        ServletUnitClient client = this.newClient();
        client.setExceptionsThrownOnErrorStatus(true);
        GetMethodQueryWebRequest req = new GetMethodQueryWebRequest("http://localhost/mycontext/services/");
        try {
            client.getResponse((WebRequest)req);
            SpringServletTest.fail();
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
    }
}

