/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.wsdlextension;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.util.logging.Logger;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;

public class WSDLExtension {
    private static final Logger LOG = Logger.getLogger(WSDLExtension.class.getName());

    public String getOptionName() {
        return "Xwsdlextension";
    }

    public String getUsage() {
        return "  -Xwsdlextension               :Activate plugin to add wsdl extension methods to generated root classes\n";
    }

    public int parseArgument(Options opt, String[] args, int index) throws BadCommandLineException, IOException {
        int ret = 0;
        if (args[index].equals("-Xwsdlextension")) {
            ret = 1;
        }
        return ret;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running WSDLExtension plugin.");
        for (ClassOutline co : outline.getClasses()) {
            this.addWSDLExtension(co);
        }
        return true;
    }

    private void addWSDLExtension(ClassOutline co) {
        JDefinedClass implementation = co.implClass;
        implementation._implements(ExtensibilityElement.class);
        JFieldVar elementTypeVar = implementation.field(2, QName.class, "elementType");
        elementTypeVar.annotate(XmlTransient.class);
        JFieldVar requiredVar = implementation.field(2, Boolean.class, "required");
        JAnnotationUse requiredAnnotation = requiredVar.annotate(XmlAttribute.class);
        requiredAnnotation.param("namespace", "http://schemas.xmlsoap.org/wsdl/");
        JMethod getElementTypeMethod = implementation.method(1, QName.class, "getElementType");
        getElementTypeMethod.body()._return(JExpr.direct((String)"elementType"));
        JMethod setElementTypeMethod = implementation.method(1, (JType)JPrimitiveType.parse((JCodeModel)co.parent().getCodeModel(), (String)"void"), "setElementType");
        setElementTypeMethod.param(QName.class, "type");
        setElementTypeMethod.body().directStatement("this.elementType = type;");
        JMethod getRequiredMethod = implementation.method(1, Boolean.class, "getRequired");
        getRequiredMethod.body()._return(JExpr.direct((String)"required == null ? false : required"));
        JMethod setRequiredMethod = implementation.method(1, (JType)JPrimitiveType.parse((JCodeModel)co.parent().getCodeModel(), (String)"void"), "setRequired");
        setRequiredMethod.param(Boolean.class, "required");
        setRequiredMethod.body().directStatement("this.required = required;");
    }
}

