/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.CodeSource;
import java.util.zip.ZipException;
import org.apache.daffodil.api.DFDL;
import org.apache.daffodil.api.DaffodilSchemaSource;
import org.apache.daffodil.api.DaffodilTunables;
import org.apache.daffodil.api.DaffodilTunables$;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.URISchemaSource;
import org.apache.daffodil.api.URISchemaSource$;
import org.apache.daffodil.api.UnitTestSchemaSource;
import org.apache.daffodil.compiler.Compiler$;
import org.apache.daffodil.compiler.InvalidParserException;
import org.apache.daffodil.compiler.InvalidParserException$;
import org.apache.daffodil.compiler.ProcessorFactory;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.externalvars.Binding;
import org.apache.daffodil.externalvars.Binding$;
import org.apache.daffodil.externalvars.ExternalVariablesLoader$;
import org.apache.daffodil.processors.DataProcessor;
import org.apache.daffodil.util.Misc$;
import org.apache.daffodil.xml.NS$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.xml.Node;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001\u0002!B\u0001)C\u0001B\u0017\u0001\u0003\u0002\u0004%\ta\u0017\u0005\t?\u0002\u0011\t\u0019!C\u0001A\"Aa\r\u0001B\u0001B\u0003&A\f\u0003\u0005h\u0001\t\u0005\r\u0011\"\u0001i\u0011!a\u0007A!a\u0001\n\u0003i\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0015B5\t\u0011A\u0004!\u00111A\u0005\nED!\"!\u0001\u0001\u0005\u0003\u0007I\u0011BA\u0002\u0011%\t9\u0001\u0001B\u0001B\u0003&!\u000fC\u0005\u0002\n\u0001\u0011\t\u0019!C\u00057\"Q\u00111\u0002\u0001\u0003\u0002\u0004%I!!\u0004\t\u0013\u0005E\u0001A!A!B\u0013a\u0006BCA\n\u0001\t\u0005\r\u0011\"\u0003\u0002\u0016!Q\u00111\u0007\u0001\u0003\u0002\u0004%I!!\u000e\t\u0015\u0005e\u0002A!A!B\u0013\t9\u0002\u0003\u0006\u0002<\u0001\u0011\t\u0019!C\u0005\u0003+A!\"!\u0010\u0001\u0005\u0003\u0007I\u0011BA \u0011)\t\u0019\u0005\u0001B\u0001B\u0003&\u0011q\u0003\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\t)\u0005\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0005\u0002n\u0001\t\n\u0011\"\u0003\u0002p!I\u0011Q\u0011\u0001\u0012\u0002\u0013%\u0011q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0005\u0003\u001bC\u0011\"!%\u0001#\u0003%I!a\u001c\t\u0013\u0005M\u0005!%A\u0005\n\u0005U\u0005\"CAM\u0001E\u0005I\u0011BAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u00111\u001b\u0001\u0005B\u0005U\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003'\u0004A\u0011AAw\u0011\u001d\t)\u0010\u0001C\u0001\u0003oDqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0002v\u0002!\tAa\u0006\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u00057\u0002A\u0011\u0001B/\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003v\u0001!\tAa\u001e\t\u000f\tU\u0004\u0001\"\u0001\u0003\u0004\"9!q\u0013\u0001\u0005\u0002\te\u0005\"\u0003BU\u0001E\u0005I\u0011AAK\u0011%\u0011Y\u000bAI\u0001\n\u0003\t)\nC\u0004\u0003.\u0002!\tAa,\t\u0013\t}\u0006!%A\u0005\u0002\u0005U\u0005\"\u0003Ba\u0001E\u0005I\u0011AAK\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqA!5\u0001\t\u0003\u0011\u0019\u000eC\u0005\u0003n\u0002\t\n\u0011\"\u0001\u0003p\"I!1\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0005k\u0004\u0011\u0013!C\u0001\u0003+;qAa>B\u0011\u0003\u0011IP\u0002\u0004A\u0003\"\u0005!1 \u0005\b\u0003\u000bRD\u0011\u0001B\u007f\u0011\u001d\u0011yP\u000fC\u0001\u0007\u0003A\u0011b!\u0002;#\u0003%\t!a\u001c\t\u000f\r\u001d!\b\"\u0003\u0004\n!I1Q\u0003\u001e\u0012\u0002\u0013%\u0011q\u000e\u0002\t\u0007>l\u0007/\u001b7fe*\u0011!iQ\u0001\tG>l\u0007/\u001b7fe*\u0011A)R\u0001\tI\u00064gm\u001c3jY*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0007\u0001\u00192\u0001A&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fMB\u0011!\u000b\u0017\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u000e\u000b1!\u00199j\u0013\t9F+\u0001\u0003E\r\u0012c\u0015B\u0001!Z\u0015\t9F+A\nwC2LG-\u0019;f\t\u001a#EjU2iK6\f7/F\u0001]!\taU,\u0003\u0002_\u001b\n9!i\\8mK\u0006t\u0017a\u0006<bY&$\u0017\r^3E\r\u0012c5k\u00195f[\u0006\u001cx\fJ3r)\t\tG\r\u0005\u0002ME&\u00111-\u0014\u0002\u0005+:LG\u000fC\u0004f\u0005\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\u000bwC2LG-\u0019;f\t\u001a#EjU2iK6\f7\u000fI\u0001\tiVt\u0017M\u00197fgV\t\u0011\u000e\u0005\u0002TU&\u00111\u000e\u0016\u0002\u0011\t\u00064gm\u001c3jYR+h.\u00192mKN\fA\u0002^;oC\ndWm]0%KF$\"!\u00198\t\u000f\u0015,\u0011\u0011!a\u0001S\u0006IA/\u001e8bE2,7\u000fI\u0001\u0016Kb$XM\u001d8bY\u00123E\t\u0014,be&\f'\r\\3t+\u0005\u0011\bcA:yu6\tAO\u0003\u0002vm\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003o6\u000b!bY8mY\u0016\u001cG/[8o\u0013\tIHOA\u0003Rk\u0016,X\r\u0005\u0002|}6\tAP\u0003\u0002~\u0007\u0006aQ\r\u001f;fe:\fGN^1sg&\u0011q\u0010 \u0002\b\u0005&tG-\u001b8h\u0003e)\u0007\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKN|F%Z9\u0015\u0007\u0005\f)\u0001C\u0004f\u0011\u0005\u0005\t\u0019\u0001:\u0002-\u0015DH/\u001a:oC2$e\t\u0012'WCJL\u0017M\u00197fg\u0002\n\u0001c\u00195fG.\fE\u000e\u001c+pa2+g/\u001a7\u0002)\rDWmY6BY2$v\u000e\u001d'fm\u0016dw\fJ3r)\r\t\u0017q\u0002\u0005\bK.\t\t\u00111\u0001]\u0003E\u0019\u0007.Z2l\u00032dGk\u001c9MKZ,G\u000eI\u0001\f_B$(k\\8u\u001d\u0006lW-\u0006\u0002\u0002\u0018A)A*!\u0007\u0002\u001e%\u0019\u00111D'\u0003\r=\u0003H/[8o!\u0011\ty\"!\f\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003GiUBAA\u0013\u0015\r\t9#S\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-R*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Wi\u0015aD8qiJ{w\u000e\u001e(b[\u0016|F%Z9\u0015\u0007\u0005\f9\u0004\u0003\u0005f\u001d\u0005\u0005\t\u0019AA\f\u00031y\u0007\u000f\u001e*p_Rt\u0015-\\3!\u0003Ay\u0007\u000f\u001e*p_Rt\u0015-\\3ta\u0006\u001cW-\u0001\u000bpaR\u0014vn\u001c;OC6,7\u000f]1dK~#S-\u001d\u000b\u0004C\u0006\u0005\u0003\u0002C3\u0012\u0003\u0003\u0005\r!a\u0006\u0002#=\u0004HOU8pi:\u000bW.Z:qC\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003\u0013\ni%a\u0014\u0002R\u0005M\u0013QKA,!\r\tY\u0005A\u0007\u0002\u0003\")!l\u0005a\u00019\")qm\u0005a\u0001S\")\u0001o\u0005a\u0001e\"1\u0011\u0011B\nA\u0002qCq!a\u0005\u0014\u0001\u0004\t9\u0002C\u0004\u0002<M\u0001\r!a\u0006\u0015\t\u0005%\u00131\f\u0005\b5R\u0001\n\u00111\u0001]\u0003\u0011\u0019w\u000e]=\u0015\u001d\u0005%\u0013\u0011MA2\u0003K\n9'!\u001b\u0002l!9!,\u0006I\u0001\u0002\u0004a\u0006bB4\u0016!\u0003\u0005\r!\u001b\u0005\baV\u0001\n\u00111\u0001s\u0011!\tI!\u0006I\u0001\u0002\u0004a\u0006\"CA\n+A\u0005\t\u0019AA\f\u0011%\tY$\u0006I\u0001\u0002\u0004\t9\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E$f\u0001/\u0002t-\u0012\u0011Q\u000f\t\u0005\u0003o\n\t)\u0004\u0002\u0002z)!\u00111PA?\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019)!\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%%fA5\u0002t\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAHU\r\u0011\u00181O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a&+\t\u0005]\u00111O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0003a\u0019X\r\u001e#jgRLgnZ;jg\",GMU8pi:{G-\u001a\u000b\u0006C\u0006}\u00151\u0015\u0005\b\u0003Cc\u0002\u0019AA\u000f\u0003\u0011q\u0017-\\3\t\u000f\u0005\u0015F\u00041\u0001\u0002\u001e\u0005Ia.Y7fgB\f7-\u001a\u0015\b9\u0005%\u0016qVAZ!\ra\u00151V\u0005\u0004\u0003[k%A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011W\u00011!\u0006\u001c8\u000fI1sOVlWM\u001c;tAQ|\u0007eY8na&dWmU8ve\u000e,G\u0006I8sA\r|W\u000e]5mK\u001aKG.\u001a\u0018\"\u0005\u0005U\u0016!\u0002\u001a/m9\u0002\u0014!G<ji\"$\u0015n\u001d;j]\u001e,\u0018n\u001d5fIJ{w\u000e\u001e(pI\u0016$b!!\u0013\u0002<\u0006u\u0006bBAQ;\u0001\u0007\u0011Q\u0004\u0005\b\u0003Kk\u0002\u0019AA\u000f\u0003Y\u0019X\r\u001e,bY&$\u0017\r^3E\r\u0012c5k\u00195f[\u0006\u001cHcA1\u0002D\"1\u0011Q\u0019\u0010A\u0002q\u000bQA^1mk\u0016DsAHAU\u0003\u0013\f\u0019,\t\u0002\u0002L\u0006IRk]3!G>t7\u000f\u001e:vGR|'\u000fI1sOVlWM\u001c;/\u0003]9\u0018\u000e\u001e5WC2LG-\u0019;f\t\u001a#EjU2iK6\f7\u000f\u0006\u0003\u0002J\u0005E\u0007BBAc?\u0001\u0007A,A\ftKR,\u0005\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKR9\u0011-a6\u0002Z\u0006m\u0007bBAQA\u0001\u0007\u0011Q\u0004\u0005\b\u0003K\u0003\u0003\u0019AA\u000f\u0011\u001d\t)\r\ta\u0001\u0003;As\u0001IAU\u0003?\f\u0019,\t\u0002\u0002b\u0006ASk]3!\t\u0006$\u0018\r\u0015:pG\u0016\u001c8o\u001c:/o&$\b.\u0012=uKJt\u0017\r\u001c,be&\f'\r\\3t]\u0005Qq-\u001a;CS:$\u0017N\\4\u0015\u000fi\f9/!;\u0002l\"9\u0011\u0011U\u0011A\u0002\u0005u\u0001bBASC\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u000b\f\u0003\u0019AA\u000f)\r\t\u0017q\u001e\u0005\u0007\u0003c\u0014\u0003\u0019\u0001>\u0002\u0011Y\f'/[1cY\u0016DsAIAU\u0003?\f\u0019,\u0001\rtKR,\u0005\u0010^3s]\u0006dGI\u0012#M-\u0006\u0014\u0018.\u00192mKN$2!YA}\u0011\u001d\tYp\ta\u0001\u0003{\f\u0011B^1sS\u0006\u0014G.Z:\u0011\u000b\u0005}(\u0011\u0002>\u000f\t\t\u0005!Q\u0001\b\u0005\u0003G\u0011\u0019!C\u0001O\u0013\r\u00119!T\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YA!\u0004\u0003\u0007M+\u0017OC\u0002\u0003\b5CsaIAU\u0003?\f\u0019,A\u000fxSRDW\t\u001f;fe:\fG\u000e\u0012$E\u0019Z\u000b'/[1cY\u0016\u001c\u0018*\u001c9m)\u0011\tIE!\u0006\t\u000f\u0005mH\u00051\u0001\u0002~R\u0019\u0011M!\u0007\t\u000f\tmQ\u00051\u0001\u0003\u001e\u0005YQ\r\u001f;WCJ\u001ch)\u001b7f!\u0011\u0011yB!\u000b\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0005K\t!![8\u000b\u0005\t\u001d\u0012\u0001\u00026bm\u0006LAAa\u000b\u0003\"\t!a)\u001b7fQ\u001d)\u0013\u0011VAp\u0003g\u000b!b]3u)Vt\u0017M\u00197f)\u0015\t'1\u0007B\u001c\u0011\u001d\u0011)D\na\u0001\u0003;\tq\u0001^;oC\ndW\rC\u0004\u0002F\u001a\u0002\r!!\b)\u000f\u0019\nIKa\u000f\u00024\u0006\u0012!QH\u0001\u0011+N,\u0007e^5uQR+h.\u00192mK:\n1b^5uQR+h.\u00192mKR1\u0011\u0011\nB\"\u0005\u000bBqA!\u000e(\u0001\u0004\ti\u0002C\u0004\u0002F\u001e\u0002\r!!\b\u0002\u0017M,G\u000fV;oC\ndWm\u001d\u000b\u0004C\n-\u0003b\u0002B'Q\u0001\u0007!qJ\u0001\fiVt\u0017M\u00197fg\u0006\u0013x\r\u0005\u0005\u0002 \tE\u0013QDA\u000f\u0013\u0011\u0011\u0019&!\r\u0003\u00075\u000b\u0007\u000fK\u0004)\u0003S\u00139&a-\"\u0005\te\u0013!E+tK\u0002:\u0018\u000e\u001e5Uk:\f'\r\\3t]\u0005aq/\u001b;i)Vt\u0017M\u00197fgR!\u0011\u0011\nB0\u0011\u001d\u0011i%\u000ba\u0001\u0005\u001f\n1c]3u\u0007\",7m[!mYR{\u0007\u000fT3wK2$2!\u0019B3\u0011\u0019\u00119G\u000ba\u00019\u0006!a\r\\1hQ\u001dQ\u0013\u0011\u0016B6\u0003g\u000b#A!\u001c\u00023U\u001bX\rI<ji\"\u001c\u0005.Z2l\u00032dGk\u001c9MKZ,GNL\u0001\u0015o&$\bn\u00115fG.\fE\u000e\u001c+pa2+g/\u001a7\u0015\t\u0005%#1\u000f\u0005\u0007\u0005OZ\u0003\u0019\u0001/\u0002\rI,Gn\\1e)\u0011\u0011IHa \u0011\u0007I\u0013Y(C\u0002\u0003~e\u0013Q\u0002R1uCB\u0013xnY3tg>\u0014\bb\u0002BAY\u0001\u0007!QD\u0001\fg\u00064X\r\u001a)beN,'\u000f\u0006\u0003\u0003z\t\u0015\u0005b\u0002BA[\u0001\u0007!q\u0011\t\u0005\u0005\u0013\u0013\u0019*\u0004\u0002\u0003\f*!!Q\u0012BH\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002\u0002BI\u0005K\t1A\\5p\u0013\u0011\u0011)Ja#\u0003'I+\u0017\rZ1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\u0002\u0017\r|W\u000e]5mK\u001aKG.\u001a\u000b\t\u00057\u0013\tK!*\u0003(B!\u00111\nBO\u0013\r\u0011y*\u0011\u0002\u0011!J|7-Z:t_J4\u0015m\u0019;pefDqAa)/\u0001\u0004\u0011i\"\u0001\u0003gS2,\u0007\"CA\n]A\u0005\t\u0019AA\f\u0011%\tYD\fI\u0001\u0002\u0004\t9\"A\u000bd_6\u0004\u0018\u000e\\3GS2,G\u0005Z3gCVdG\u000f\n\u001a\u0002+\r|W\u000e]5mK\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005i1m\\7qS2,7k\\;sG\u0016$\u0002Ba'\u00032\nm&Q\u0018\u0005\b\u0005g\u000b\u0004\u0019\u0001B[\u00031\u00198\r[3nCN{WO]2f!\r\u0019&qW\u0005\u0004\u0005s#&\u0001\u0006#bM\u001a|G-\u001b7TG\",W.Y*pkJ\u001cW\rC\u0005\u0002\u0014E\u0002\n\u00111\u0001\u0002\u0018!I\u00111H\u0019\u0011\u0002\u0003\u0007\u0011qC\u0001\u0018G>l\u0007/\u001b7f'>,(oY3%I\u00164\u0017-\u001e7uII\nqcY8na&dWmU8ve\u000e,G\u0005Z3gCVdG\u000fJ\u001a\u0002+\r|W\u000e]5mKN{WO]2f\u0013:$XM\u001d8bYRA!1\u0014Bd\u0005\u0013\u0014i\rC\u0004\u00034R\u0002\rA!.\t\u000f\t-G\u00071\u0001\u0002\u0018\u0005qq\u000e\u001d;S_>$h*Y7f\u0003J<\u0007b\u0002Bhi\u0001\u0007\u0011qC\u0001\u0014_B$(k\\8u\u001d\u0006lWm\u001d9bG\u0016\f%oZ\u0001\fG>l\u0007/\u001b7f\u001d>$W\r\u0006\u0006\u0003\u001c\nU'1\u001dBu\u0005WDqAa66\u0001\u0004\u0011I.A\u0002y[2\u0004BAa7\u0003`6\u0011!Q\u001c\u0006\u0004\u0005/l\u0015\u0002\u0002Bq\u0005;\u0014AAT8eK\"I!Q]\u001b\u0011\u0002\u0003\u0007!q]\u0001\n_B$H+\u001c9ESJ\u0004R\u0001TA\r\u0005;A\u0011\"a\u00056!\u0003\u0005\r!a\u0006\t\u0013\u0005mR\u0007%AA\u0002\u0005]\u0011!F2p[BLG.\u001a(pI\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005cTCAa:\u0002t\u0005)2m\\7qS2,gj\u001c3fI\u0011,g-Y;mi\u0012\u001a\u0014!F2p[BLG.\u001a(pI\u0016$C-\u001a4bk2$H\u0005N\u0001\t\u0007>l\u0007/\u001b7feB\u0019\u00111\n\u001e\u0014\u0005iZEC\u0001B}\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tIea\u0001\t\u000fic\u0004\u0013!a\u00019\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\rd_6\u0004\u0018\u000e\\3T_V\u00148-Z*z]\u000eD'o\u001c8ju\u0016\u0014HC\u0003BN\u0007\u0017\u0019ya!\u0005\u0004\u0014!91Q\u0002 A\u0002\u0005%\u0013!A2\t\u000f\tMf\b1\u0001\u00036\"9\u00111\u0003 A\u0002\u0005]\u0001bBA\u001e}\u0001\u0007\u0011qC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019")
public class Compiler
implements DFDL.Compiler {
    private boolean validateDFDLSchemas;
    private DaffodilTunables tunables;
    private Queue<Binding> externalDFDLVariables;
    private boolean checkAllTopLevel;
    private Option<String> optRootName;
    private Option<String> optRootNamespace;

    public static boolean apply$default$1() {
        return Compiler$.MODULE$.apply$default$1();
    }

    public static Compiler apply(boolean bl) {
        return Compiler$.MODULE$.apply(bl);
    }

    public boolean validateDFDLSchemas() {
        return this.validateDFDLSchemas;
    }

    public void validateDFDLSchemas_$eq(boolean x$1) {
        this.validateDFDLSchemas = x$1;
    }

    public DaffodilTunables tunables() {
        return this.tunables;
    }

    public void tunables_$eq(DaffodilTunables x$1) {
        this.tunables = x$1;
    }

    private Queue<Binding> externalDFDLVariables() {
        return this.externalDFDLVariables;
    }

    private void externalDFDLVariables_$eq(Queue<Binding> x$1) {
        this.externalDFDLVariables = x$1;
    }

    private boolean checkAllTopLevel() {
        return this.checkAllTopLevel;
    }

    private void checkAllTopLevel_$eq(boolean x$1) {
        this.checkAllTopLevel = x$1;
    }

    private Option<String> optRootName() {
        return this.optRootName;
    }

    private void optRootName_$eq(Option<String> x$1) {
        this.optRootName = x$1;
    }

    private Option<String> optRootNamespace() {
        return this.optRootNamespace;
    }

    private void optRootNamespace_$eq(Option<String> x$1) {
        this.optRootNamespace = x$1;
    }

    private Compiler copy(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        return new Compiler(validateDFDLSchemas, tunables, externalDFDLVariables, checkAllTopLevel, optRootName, optRootNamespace);
    }

    private boolean copy$default$1() {
        return this.validateDFDLSchemas();
    }

    private DaffodilTunables copy$default$2() {
        return this.tunables();
    }

    private Queue<Binding> copy$default$3() {
        return this.externalDFDLVariables();
    }

    private boolean copy$default$4() {
        return this.checkAllTopLevel();
    }

    private Option<String> copy$default$5() {
        return this.optRootName();
    }

    private Option<String> copy$default$6() {
        return this.optRootNamespace();
    }

    public void setDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        this.optRootName_$eq((Option<String>)Option$.MODULE$.apply((Object)name));
        this.optRootNamespace_$eq((Option<String>)Option$.MODULE$.apply((Object)namespace));
    }

    public Compiler withDistinguishedRootNode(String name, String namespace) {
        if (name == null) {
            throw Assert$.MODULE$.abort("Usage error: name.ne(null)");
        }
        Option x$1 = Option$.MODULE$.apply((Object)name);
        Option x$2 = Option$.MODULE$.apply((Object)namespace);
        boolean x$3 = this.copy$default$1();
        DaffodilTunables x$4 = this.copy$default$2();
        Queue<Binding> x$5 = this.copy$default$3();
        boolean x$6 = this.copy$default$4();
        return this.copy(x$3, x$4, x$5, x$6, (Option<String>)x$1, (Option<String>)x$2);
    }

    public void setValidateDFDLSchemas(boolean value) {
        this.validateDFDLSchemas_$eq(value);
    }

    public Compiler withValidateDFDLSchemas(boolean value) {
        return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public void setExternalDFDLVariable(String name, String namespace, String value) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)this.getBinding(name, namespace, value)));
    }

    private Binding getBinding(String name, String namespace, String value) {
        String string = namespace;
        Object object = string == null ? None$.MODULE$ : new Some((Object)NS$.MODULE$.apply(namespace));
        None$ ns = object;
        Binding b = Binding$.MODULE$.apply(name, (Option)ns, value);
        return b;
    }

    public void setExternalDFDLVariable(Binding variable) {
        this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)variable));
    }

    public void setExternalDFDLVariables(Seq<Binding> variables) {
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public Compiler withExternalDFDLVariablesImpl(Seq<Binding> variables) {
        ObjectRef extVars = ObjectRef.create(this.externalDFDLVariables());
        variables.foreach((Function1 & Serializable & scala.Serializable)b -> {
            extVars.elem = ((Queue)extVars.elem).enqueue((Object)b);
            return BoxedUnit.UNIT;
        });
        Queue x$1 = (Queue)extVars.elem;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, (Queue<Binding>)x$1, x$4, x$5, x$6);
    }

    public void setExternalDFDLVariables(File extVarsFile) {
        Queue extVars = ExternalVariablesLoader$.MODULE$.fileToBindings(extVarsFile);
        extVars.foreach((Function1 & Serializable & scala.Serializable)b -> {
            this.externalDFDLVariables_$eq((Queue<Binding>)this.externalDFDLVariables().enqueue((Object)b));
            return BoxedUnit.UNIT;
        });
    }

    public void setTunable(String tunable, String value) {
        this.tunables_$eq(this.tunables().setTunable(tunable, value));
    }

    public Compiler withTunable(String tunable, String value) {
        DaffodilTunables x$1 = this.tunables().setTunable(tunable, value);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setTunables(Map<String, String> tunablesArg) {
        this.tunables_$eq(this.tunables().setTunables(tunablesArg));
    }

    public Compiler withTunables(Map<String, String> tunablesArg) {
        DaffodilTunables x$1 = this.tunables().setTunables(tunablesArg);
        boolean x$2 = this.copy$default$1();
        Queue<Binding> x$3 = this.copy$default$3();
        boolean x$4 = this.copy$default$4();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
    }

    public void setCheckAllTopLevel(boolean flag) {
        this.checkAllTopLevel_$eq(flag);
    }

    public Compiler withCheckAllTopLevel(boolean flag) {
        boolean x$1 = flag;
        boolean x$2 = this.copy$default$1();
        DaffodilTunables x$3 = this.copy$default$2();
        Queue<Binding> x$4 = this.copy$default$3();
        Option<String> x$5 = this.copy$default$5();
        Option<String> x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    public DFDL.DataProcessor reload(File savedParser) {
        return this.reload(new FileInputStream(savedParser).getChannel());
    }

    public DFDL.DataProcessor reload(ReadableByteChannel savedParser) {
        DataProcessor dataProcessor;
        try {
            DataProcessor dp;
            String savedVersion;
            InputStream is = Channels.newInputStream(savedParser);
            String requiredDataPrefix = "DAFFODIL ";
            new StringOps(Predef$.MODULE$.augmentString(requiredDataPrefix)).foreach((Function1 & Serializable & scala.Serializable)c -> {
                Compiler.$anonfun$reload$1(is, BoxesRunTime.unboxToChar((Object)c));
                return BoxedUnit.UNIT;
            });
            ArrayBuffer ab = new ArrayBuffer();
            int n = -1;
            while ((n = is.read()) > 0) {
                ab.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)n}));
            }
            if (n == -1) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            String curVersion = Misc$.MODULE$.getDaffodilVersion();
            String string = savedVersion = new String((byte[])ab.toArray(ClassTag$.MODULE$.Byte()), "utf-8");
            String string2 = curVersion;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidParserException(new StringBuilder(71).append("The saved parser is only compatible with Daffodil ").append(savedVersion).append(". Current version is ").append(curVersion).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            ObjectInputStream objInput = new ObjectInputStream(null, is){

                public Class<?> resolveClass(ObjectStreamClass desc) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(desc.getName(), false, this.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        clazz = super.resolveClass(desc);
                    }
                    return clazz;
                }
            };
            Object dpObj = objInput.readObject();
            objInput.close();
            dataProcessor = dp = (DataProcessor)dpObj;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipException) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            if (throwable2 instanceof StreamCorruptedException) {
                throw new InvalidParserException("The saved parser is corrupted", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            if (throwable2 instanceof InvalidClassException) {
                InvalidClassException invalidClassException = (InvalidClassException)throwable2;
                Class<?> cls = Class.forName(invalidClassException.classname);
                CodeSource src = cls.getProtectionDomain().getCodeSource();
                String dependencyStr = src != null ? new File(src.getLocation().getFile()).getName() : "a dependency";
                throw new InvalidParserException(new StringBuilder(83).append("The saved parser was created with a different version of ").append(dependencyStr).append(" with incompatible class: ").append(invalidClassException.classname).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (bl) {
                throw new InvalidParserException(new StringBuilder(113).append("The saved parser was created with a different set of dependencies containing a class no longer on the classpath: ").append(throwable2.getMessage()).toString(), InvalidParserException$.MODULE$.$lessinit$greater$default$2());
            }
            throw throwable;
        }
        return dataProcessor;
    }

    public ProcessorFactory compileFile(File file, Option<String> optRootName, Option<String> optRootNamespace) {
        URISchemaSource source = URISchemaSource$.MODULE$.apply(file.toURI());
        return this.compileSource((DaffodilSchemaSource)source, (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<String> compileFile$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileFile$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory compileSource(DaffodilSchemaSource schemaSource, Option<String> optRootName, Option<String> optRootNamespace) {
        return Compiler$.MODULE$.org$apache$daffodil$compiler$Compiler$$compileSourceSynchronizer(this, schemaSource, optRootName, optRootNamespace);
    }

    public Option<String> compileSource$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileSource$default$3() {
        return None$.MODULE$;
    }

    public ProcessorFactory org$apache$daffodil$compiler$Compiler$$compileSourceInternal(DaffodilSchemaSource schemaSource, Option<String> optRootNameArg, Option<String> optRootNamespaceArg) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Option rootName = optRootNameArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootName());
        Option rootNamespace = optRootNamespaceArg.orElse((Function0 & Serializable & scala.Serializable)() -> this.optRootNamespace());
        ProcessorFactory pf = new ProcessorFactory((Option<String>)rootName, (Option<String>)rootNamespace, this.externalDFDLVariables(), schemaSource, this.validateDFDLSchemas(), this.checkAllTopLevel(), this.tunables());
        boolean err = pf.isError();
        Seq<Diagnostic> diags = pf.getDiagnostics();
        if (err) {
            if (!diags.nonEmpty()) {
                throw Assert$.MODULE$.abort("Invariant broken: diags.nonEmpty");
            }
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(57).append("Compilation (ProcessorFactory) produced ").append(diags.length()).append(" errors/warnings.").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (diags.nonEmpty()) {
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(50).append("Compilation (ProcessorFactory) produced ").append(diags.length()).append(" warnings.").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)"ProcessorFactory completed with no errors.", null);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(21).append("Schema had ").append(pf.elementBaseInstanceCount()).append(" elements.").toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pf;
    }

    public ProcessorFactory compileNode(Node xml, Option<File> optTmpDir, Option<String> optRootName, Option<String> optRootNamespace) {
        return this.compileSource((DaffodilSchemaSource)new UnitTestSchemaSource(xml, "anon", optTmpDir), (Option)optRootName, (Option)optRootNamespace);
    }

    public Option<File> compileNode$default$2() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$3() {
        return None$.MODULE$;
    }

    public Option<String> compileNode$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$reload$1(InputStream is$1, char c) {
        if (is$1.read() != c) {
            throw new InvalidParserException("The saved parser is only compatible with an older version of Daffodil", InvalidParserException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private Compiler(boolean validateDFDLSchemas, DaffodilTunables tunables, Queue<Binding> externalDFDLVariables, boolean checkAllTopLevel, Option<String> optRootName, Option<String> optRootNamespace) {
        this.validateDFDLSchemas = validateDFDLSchemas;
        this.tunables = tunables;
        this.externalDFDLVariables = externalDFDLVariables;
        this.checkAllTopLevel = checkAllTopLevel;
        this.optRootName = optRootName;
        this.optRootNamespace = optRootNamespace;
    }

    public Compiler(boolean validateDFDLSchemas) {
        this(validateDFDLSchemas, DaffodilTunables$.MODULE$.apply(), (Queue<Binding>)Queue$.MODULE$.empty(), true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }
}

