/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.equality.package$;
import org.apache.daffodil.equality.package$TypeEqual$;
import org.apache.daffodil.equality.package$TypeEquality$;
import org.apache.daffodil.util.Bits$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.xml.include.sax.EncodingHeuristics$;

public final class Misc$ {
    public static Misc$ MODULE$;
    private Seq<URL> classPath;
    private final char[] hexLookup;
    private final Charset bytesCharset;
    private final CharsetDecoder bytesDecoder;
    private volatile boolean bitmap$0;

    static {
        new Misc$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public <T> Option<T> boolToOpt(boolean test, Function0<T> thing) {
        return test ? new Some(thing.apply()) : None$.MODULE$;
    }

    public String getNameFromClass(Object obj) {
        if (obj == null) {
            return "null";
        }
        String nonPackageClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getName().split("\\."))).toList().reverse().head();
        List nonDollarsParts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonPackageClassName.split("\\$"))).toList().reverse();
        List nonNumericParts = (List)nonDollarsParts.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches("\\d*")));
        String nameToken = (String)nonNumericParts.head();
        return nameToken;
    }

    public String stripSuffix(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    /*
     * WARNING - void declaration
     */
    public String stripQuotes(String s) {
        void var3_3;
        String stripFirst = s.startsWith("\"") ? s.substring(1) : s;
        String stripLast = stripFirst.endsWith("\"") ? stripFirst.substring(0, stripFirst.length() - 1) : stripFirst;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNullOrBlank(String s) {
        void var2_2;
        boolean b = Option$.MODULE$.apply((Object)s).isEmpty() || s.trim().isEmpty();
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFileURI(URI uri) {
        boolean bl;
        if (uri.isAbsolute()) {
            void var3_4;
            String protocol;
            String string = protocol = uri.toURL().getProtocol();
            String string2 = "file";
            boolean result = !(string != null ? !string.equals(string2) : string2 != null);
            bl = var3_4;
        } else {
            bl = false;
        }
        return bl;
    }

    public Tuple2<Option<URI>, String> getResourceOption(String resourcePathRaw) {
        String resourcePath = resourcePathRaw.replaceAll("\\s", "%20");
        String resPath = resourcePath.startsWith("/") ? resourcePath : new java.lang.StringBuilder(1).append("/").append(resourcePath).toString();
        URL res = this.getClass().getResource(resPath);
        return res == null ? new Tuple2((Object)None$.MODULE$, (Object)resPath) : new Tuple2((Object)new Some((Object)res.toURI()), (Object)resPath);
    }

    public Option<URI> getResourceRelativeOption(String rawResName, Option<URI> optContextURI) {
        Option maybeRes;
        String resName = rawResName.replaceAll("\\s", "%20");
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = maybeRes = (Option)tuple2._1();
        Option maybeRes2 = option;
        return maybeRes2.isDefined() ? maybeRes2 : optContextURI.flatMap((Function1 & Serializable & scala.Serializable)contextURI -> {
            URL contextURL = contextURI.toURL();
            URL completeURL = new URL(contextURL, resName);
            Option<URI> res = MODULE$.tryURL(completeURL);
            return res;
        });
    }

    public Option<URI> searchResourceOption(String resName, Option<URI> relativeTo) {
        URI resAsURI = new URI(resName);
        Path resPath = resAsURI.getScheme() != null ? Paths.get(resAsURI) : Paths.get(resName, new String[0]);
        Some resolvedURI = Files.exists(resPath, new LinkOption[0]) ? new Some((Object)resPath.toFile().toURI()) : this.getResourceRelativeOption(resName, relativeTo);
        Option res = resolvedURI.orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<URI> option;
            String[] parts = resName.split("/");
            if (parts.length > 1) {
                Option<URI> secondTry;
                String filePart = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last();
                option = secondTry = MODULE$.searchResourceOption(filePart, relativeTo);
            } else {
                option = None$.MODULE$;
            }
            return option;
        });
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private Option<URI> tryURL(URL url) {
        void var3_5;
        None$ none$;
        try (InputStream is = null;){
            try {
                is = url.openStream();
                none$ = new Some((Object)url.toURI());
            }
            catch (IOException e) {
                none$ = None$.MODULE$;
            }
        }
        None$ res = none$;
        return var3_5;
    }

    private Seq<URL> classPath$lzycompute() {
        Misc$ misc$ = this;
        synchronized (misc$) {
            if (!this.bitmap$0) {
                Seq urls;
                Seq seq;
                ClassLoader cl = this.getClass().getClassLoader();
                ClassLoader classLoader = cl;
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                    seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).toSeq();
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                this.classPath = urls = seq;
                this.bitmap$0 = true;
            }
        }
        return this.classPath;
    }

    public Seq<URL> classPath() {
        return !this.bitmap$0 ? this.classPath$lzycompute() : this.classPath;
    }

    public URI getRequiredResource(String resourcePath) {
        URI res;
        Option option;
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resourcePath);
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            String resPath = (String)tuple2._2();
            if (None$.MODULE$.equals(option2)) {
                String msg = new java.lang.StringBuilder(47).append("Required resource ").append(resPath).append(" was not found.\nClasspath is ").append((Object)(this.classPath().length() == 0 ? "unknown." : new java.lang.StringBuilder(2).append(": ").append(this.classPath().mkString("\n")).toString())).toString();
                throw new FileNotFoundException(msg);
            }
        }
        if (tuple2 == null || !((option = (Option)tuple2._1()) instanceof Some)) {
            throw new MatchError(tuple2);
        }
        Some some = (Some)option;
        URI uRI = res = (URI)some.value();
        return uRI;
    }

    public String initialUpperCase(String s) {
        return new java.lang.StringBuilder(0).append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head())))).append(s.substring(1)).toString();
    }

    public String initialLowerCase(String s) {
        return new java.lang.StringBuilder(0).append(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head())))).append(s.substring(1)).toString();
    }

    public String toInitialLowerCaseUnlessAllUpperCase(String s) {
        if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)))) {
            return s;
        }
        return this.isAllUpper(s, 1) ? s : new java.lang.StringBuilder(0).append(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)))).append(s.substring(1)).toString();
    }

    public boolean isAllUpper(String s, int start) {
        int l = s.length();
        for (int i = start; i < l; ++i) {
            if (!RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i)))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllWhitespace(StringBuilder sb) {
        boolean bl;
        if (sb.isEmpty()) {
            bl = false;
        } else {
            int sbLen = sb.length();
            for (int in = 0; in < sbLen; ++in) {
                if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(sb.charAt(in)))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public String getDaffodilVersion() {
        void var1_1;
        String implVersion = this.getClass().getPackage().getImplementationVersion();
        return implVersion == null ? "" : var1_1;
    }

    public byte[] hex2Bytes(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(59).append("Hex string must have an even number of characters, but was ").append(len).toString());
        }
        int numBytes = len / 2;
        byte[] arr = new byte[numBytes];
        int arrIdx = 0;
        int hexIdx = 0;
        while (arrIdx < numBytes) {
            int l = Misc$.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx));
            int r = Misc$.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx + 1));
            arr[arrIdx] = (byte)(l << 4 | r);
            ++arrIdx;
            hexIdx += 2;
        }
        return arr;
    }

    public String hex2Bits(String hex) {
        IndexedSeq nums = (IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(hex)).map((Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToInteger((int)Misc$.$anonfun$hex2Bits$1(BoxesRunTime.unboxToChar((Object)ch))), Predef$.MODULE$.fallbackStringCanBuildFrom());
        IndexedSeq bits = (IndexedSeq)nums.map((Function1 & Serializable & scala.Serializable)x$2 -> Misc$.$anonfun$hex2Bits$2(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq paddedBits = (IndexedSeq)bits.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString("%4s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$3})).replaceAll(" ", "0"), IndexedSeq$.MODULE$.canBuildFrom());
        String res = paddedBits.mkString();
        return res;
    }

    private char[] hexLookup() {
        return this.hexLookup;
    }

    public String bytes2Hex(byte[] bytes) {
        char[] hexArr = new char[bytes.length * 2];
        int bytIdx = 0;
        int hexIdx = 0;
        while (bytIdx < bytes.length) {
            int b = bytes[bytIdx] & 0xFF;
            hexArr[hexIdx] = this.hexLookup()[b >>> 4];
            hexArr[hexIdx + 1] = this.hexLookup()[b & 0xF];
            ++bytIdx;
            hexIdx += 2;
        }
        return new String(hexArr);
    }

    public byte[] bits2Bytes(String bits) {
        return bits.isEmpty() ? (byte[])Nil$.MODULE$.toArray(ClassTag$.MODULE$.Byte()) : this.bits2Bytes((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bits}))));
    }

    public byte[] bits2Bytes(Seq<String> bits) {
        String allBitsOnly = ((TraversableOnce)bits.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4.split("[^01]"))), Seq$.MODULE$.canBuildFrom())).mkString();
        Iterator byteSizedBits = new StringOps(Predef$.MODULE$.augmentString(allBitsOnly)).sliding(8, 8);
        return (byte[])byteSizedBits.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToByte((byte)Misc$.$anonfun$bits2Bytes$2(x$5))).toArray(ClassTag$.MODULE$.Byte());
    }

    public String bytes2Bits(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)b -> Misc$.$anonfun$bytes2Bits$1(BoxesRunTime.unboxToByte((Object)b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    public ReadableByteChannel stringToReadableByteChannel(String s) {
        byte[] bytes = s.getBytes("utf-8");
        return this.byteArrayToReadableByteChannel(bytes);
    }

    public WritableByteChannel stringToWritableByteChannel(String s) {
        int size = s.length();
        return this.byteArrayToWritableByteChannel(size);
    }

    /*
     * WARNING - void declaration
     */
    public ReadableByteChannel byteArrayToReadableByteChannel(byte[] bytes) {
        void var3_3;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public WritableByteChannel byteArrayToWritableByteChannel(int size) {
        void var3_3;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(size);
        WritableByteChannel wbc = Channels.newChannel(outputStream);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ReadableByteChannel fileToReadableByteChannel(File file) {
        void var3_3;
        FileInputStream inputStream = new FileInputStream(file);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return var3_3;
    }

    public String remapControlsAndLineEndingsToVisibleGlyphs(String s) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)Misc$.MODULE$.remapControlOrLineEndingToVisibleGlyphs(BoxesRunTime.unboxToChar((Object)x$6))), Predef$.MODULE$.StringCanBuildFrom()))).mkString();
    }

    public char remapControlOrLineEndingToVisibleGlyphs(char c) {
        boolean bl;
        int URC = 9254;
        char c2 = c;
        int n = c2 <= '\u001f' ? c2 + 9216 : (' ' == c2 ? 9251 : ('\u007f' == c2 ? 9249 : ('\u00a0' == c2 ? URC : ('\u200b' == c2 ? URC : ('\u2028' == c2 ? URC : ('\u2029' == c2 ? URC : ('\u200c' == c2 ? URC : ('\u200d' == c2 ? URC : ('\u2060' == c2 ? URC : ((bl = '\u200e' == c2 ? true : '\u200f' == c2) ? URC : (c2 >= '\u202a' && c2 <= '\u202e' ? URC : ('\ufffe' == c2 ? URC : ('\uffff' == c2 ? URC : (c2 > '\u2400' && c2 < '\u2423' ? URC : (int)c))))))))))))));
        int code = n;
        return (char)code;
    }

    private Charset bytesCharset() {
        return this.bytesCharset;
    }

    private CharsetDecoder bytesDecoder() {
        return this.bytesDecoder;
    }

    public void remapBytesToVisibleGlyphs(ByteBuffer bb, CharBuffer cb) {
        int numBytes = bb.remaining();
        this.bytesDecoder().decode(bb, cb, true);
        cb.flip();
        for (int i = 0; i < numBytes; ++i) {
            int newCodepoint = this.remapOneByteToVisibleGlyph(bb.get(i));
            Object object = newCodepoint != -1 ? cb.put(i, (char)newCodepoint) : BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int remapCodepointToVisibleGlyph(int codepoint) {
        void var3_3;
        if (codepoint > 255 || codepoint < -128) {
            return codepoint;
        }
        byte b = (byte)codepoint;
        int r = this.remapOneByteToVisibleGlyph(b);
        return r == -1 ? codepoint : var3_3;
    }

    public String remapStringToVisibleGlyphs(String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)Misc$.$anonfun$remapStringToVisibleGlyphs$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom());
    }

    public String remapBytesToStringOfVisibleGlyphs(byte[] ba) {
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ba)).map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToCharacter((char)Misc$.$anonfun$remapBytesToStringOfVisibleGlyphs$1(BoxesRunTime.unboxToByte((Object)b))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString();
    }

    public int remapByteToVisibleGlyph(byte b) {
        ByteBuffer bb = ByteBuffer.allocate(1);
        bb.put(0, b);
        CharBuffer cb = CharBuffer.allocate(1);
        this.remapBytesToVisibleGlyphs(bb, cb);
        return cb.get(0);
    }

    private int remapOneByteToVisibleGlyph(byte b) {
        int n = Bits$.MODULE$.asUnsignedByte(b);
        int n2 = n <= 31 ? n + 9216 : (32 == n ? 9251 : (127 == n ? 9249 : (129 == n ? 385 : (141 == n ? 397 : (143 == n ? 399 : (144 == n ? 400 : (157 == n ? 413 : (160 == n ? 9250 : (173 == n ? 45 : -1)))))))));
        return n2;
    }

    public boolean isAsciiBased(String csName) {
        return this.isAsciiBased(Charset.forName(csName));
    }

    public boolean isAsciiBased(Charset cs) {
        boolean bl;
        Seq aliases = (Seq)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(cs.aliases()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toUpperCase(), Seq$.MODULE$.canBuildFrom());
        boolean byName = aliases.exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Misc$.$anonfun$isAsciiBased$2(s)));
        if (byName) {
            bl = byName;
        } else {
            CharsetDecoder decoder = cs.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            byte[] abcBytes = "abc".getBytes("ascii");
            ByteBuffer bb = ByteBuffer.wrap(abcBytes);
            CharBuffer cb = decoder.decode(bb);
            String abc = cb.toString();
            bl = package$TypeEqual$.MODULE$.$eq$colon$eq$extension(package$.MODULE$.TypeEqual(abc), "abc", package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
        }
        return bl;
    }

    public <A, B> B using(A param, Function1<A, B> f) {
        Object object;
        try {
            object = f.apply(param);
        }
        catch (Throwable throwable) {
            A qual1 = param;
            try {
                Misc$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        Object object2 = object;
        A qual1 = param;
        try {
            Misc$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return (B)object2;
    }

    public void writeToFile(String fileName, Function1<Writer, BoxedUnit> body) {
        FileWriter writer = new FileWriter(fileName);
        this.using(writer, (Function1 & Serializable & scala.Serializable)x$8 -> {
            body.apply((Object)x$8);
            return BoxedUnit.UNIT;
        });
    }

    public String determineEncoding(URI uri) {
        EncodingHeuristics$ encH = EncodingHeuristics$.MODULE$;
        InputStream is = uri.toURL().openStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        String enc = encH.readEncodingFromStream((InputStream)bis);
        is.close();
        return enc;
    }

    public String determineEncoding(File file) {
        return this.determineEncoding(file.toURI());
    }

    public String csToString(CharSequence cs) {
        String string;
        CharSequence charSequence = cs;
        if (charSequence instanceof String) {
            String string2;
            string = string2 = (String)charSequence;
        } else {
            StringBuilder sb = new StringBuilder(cs.length());
            sb.append((Object)cs);
            string = sb.mkString();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public Some<String> getSomeMessage(Throwable th) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        m = th.getMessage();
                        var7_4 = new Tuple2((Object)m, (Object)(c = th.getCause()));
                        if (var7_4 == null) break block5;
                        var8_5 = (String)var7_4._1();
                        var9_6 = (Throwable)var7_4._2();
                        if (var8_5 != null || var9_6 != null) break block5;
                        var2_7 = this.getNameFromClass(th);
                        break block6;
                    }
                    if (var7_4 == null) break block7;
                    var10_8 = (String)var7_4._1();
                    var11_9 = (Throwable)var7_4._2();
                    if (!"".equals(var10_8) || var11_9 != null) break block7;
                    var2_7 = this.getNameFromClass(th);
                    break block6;
                }
                if (var7_4 == null) break block8;
                m = (String)var7_4._1();
                var13_11 = (Throwable)var7_4._2();
                if (var13_11 != null) break block8;
                var2_7 = m;
                break block6;
            }
            if (var7_4 == null) ** GOTO lbl-1000
            var14_12 = (String)var7_4._1();
            c = (Throwable)var7_4._2();
            if (var14_12 == null) {
                var2_7 = (String)this.getSomeMessage(c).get();
            } else if (var7_4 != null) {
                m = (String)var7_4._1();
                c = (Throwable)var7_4._2();
                var19_16 = this.getSomeMessage(c);
                if (var19_16 == null) {
                    throw new MatchError(var19_16);
                }
                var3_18 = cmsg = (String)var19_16.value();
                cmsg = var3_18;
                var2_7 = new java.lang.StringBuilder(10).append(cmsg).append(" (within ").append(m).append(")").toString();
            } else {
                throw new MatchError((Object)var7_4);
            }
        }
        res = var2_7;
        return new Some((Object)res);
    }

    public Some<Throwable> getSomeCause(Throwable th) {
        Throwable c = th.getCause();
        Throwable throwable = c;
        Throwable throwable2 = throwable == null ? th : (Throwable)this.getSomeCause(c).get();
        Throwable res = throwable2;
        return new Some((Object)res);
    }

    /*
     * WARNING - void declaration
     */
    private static final int hexCharToValue$1(char c) {
        void var2_2;
        int n;
        char i = c;
        if (i >= '0' && i <= '9') {
            n = i - 48;
        } else if (i >= 'A' && i <= 'F') {
            n = i - 65 + 10;
        } else if (i >= 'a' && i <= 'f') {
            n = i - 97 + 10;
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(50).append("Hex character must be 0-9, a-z, or A-Z, but was '").append(c).append("'").toString());
        }
        int v = n;
        return (int)var2_2;
    }

    public static final /* synthetic */ int $anonfun$hex2Bits$1(char ch) {
        return Integer.parseInt(((Object)BoxesRunTime.boxToCharacter((char)ch)).toString(), 16);
    }

    public static final /* synthetic */ String $anonfun$hex2Bits$2(int x$2) {
        return Long.toString(x$2, 2);
    }

    public static final /* synthetic */ byte $anonfun$bits2Bytes$2(String x$5) {
        return (byte)Integer.parseInt(x$5, 2);
    }

    public static final /* synthetic */ String $anonfun$bytes2Bits$1(byte b) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(b & 0xFF)))).reverse())).padTo(8, (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom()))).reverse();
    }

    public static final /* synthetic */ char $anonfun$remapStringToVisibleGlyphs$1(char c) {
        return (char)MODULE$.remapCodepointToVisibleGlyph(c);
    }

    public static final /* synthetic */ char $anonfun$remapBytesToStringOfVisibleGlyphs$1(byte b) {
        return (char)MODULE$.remapCodepointToVisibleGlyph(b);
    }

    public static final /* synthetic */ boolean $anonfun$isAsciiBased$2(String s) {
        return !s.contains("7-BIT") && !s.contains("EBCDIC") && (s.startsWith("ASCII") || s.startsWith("US-ASCII") || s.startsWith("ISO-8859") || s.startsWith("UTF"));
    }

    /*
     * WARNING - void declaration
     */
    private Misc$() {
        void var1_1;
        MODULE$ = this;
        this.hexLookup = (char[])new StringOps(Predef$.MODULE$.augmentString("0123456789ABCDEF")).toArray(ClassTag$.MODULE$.Char());
        this.bytesCharset = Charset.forName("windows-1252");
        CharsetDecoder decoder = this.bytesCharset().newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bytesDecoder = var1_1;
    }
}

