/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.util;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.daffodil.xml.DFDLCatalogResolver;
import org.apache.daffodil.xml.DFDLCatalogResolver$;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.xml.parsing.NoBindingFactoryAdapter;

public final class Validator$
extends NoBindingFactoryAdapter {
    public static Validator$ MODULE$;
    private final ThreadLocal<HashMap<Seq<String>, Validator>> validationSchemaCache;

    static {
        new Validator$();
    }

    private ThreadLocal<HashMap<Seq<String>, Validator>> validationSchemaCache() {
        return this.validationSchemaCache;
    }

    public void validateXMLSources(Seq<String> schemaFileNames, InputStream document, ErrorHandler errHandler) {
        Validator validator;
        HashMap<Seq<String>, Validator> cache = this.validationSchemaCache().get();
        Option optCachedValidator = cache.get(schemaFileNames);
        Option option = optCachedValidator;
        if (option instanceof Some) {
            Validator validator2;
            Some some = (Some)option;
            Validator cachedValidator = (Validator)some.value();
            cachedValidator.reset();
            DFDLCatalogResolver resolver = DFDLCatalogResolver$.MODULE$.get();
            validator = validator2 = this.initializeValidator(cachedValidator, errHandler, resolver);
        } else if (None$.MODULE$.equals(option)) {
            Seq schemaSources = (Seq)schemaFileNames.map((Function1 & Serializable & scala.Serializable)fn -> {
                void var3_3;
                URI uri = new URI((String)fn);
                InputStream is = uri.toURL().openStream();
                StreamSource stream = new StreamSource(is);
                stream.setSystemId(uri.toString());
                return var3_3;
            }, Seq$.MODULE$.canBuildFrom());
            XMLSchemaFactory factory = new XMLSchemaFactory();
            factory.setErrorHandler(errHandler);
            DFDLCatalogResolver resolver = DFDLCatalogResolver$.MODULE$.get();
            factory.setResourceResolver((LSResourceResolver)resolver);
            Schema schema = factory.newSchema((Source[])schemaSources.toArray(ClassTag$.MODULE$.apply(Source.class)));
            Validator validator3 = this.initializeValidator(schema.newValidator(), errHandler, resolver);
            cache.put(schemaFileNames, (Object)validator3);
            validator = validator3;
        } else {
            throw new MatchError((Object)option);
        }
        Validator validator4 = validator;
        StreamSource documentSource = new StreamSource(document);
        validator4.validate(documentSource);
    }

    public Validator initializeValidator(Validator validator, ErrorHandler errHandler, DFDLCatalogResolver resolver) {
        validator.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        validator.setFeature("http://xml.org/sax/features/validation", true);
        validator.setFeature("http://apache.org/xml/features/validation/schema", true);
        validator.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        validator.setErrorHandler(errHandler);
        validator.setResourceResolver(resolver);
        return validator;
    }

    private Validator$() {
        MODULE$ = this;
        this.validationSchemaCache = new ThreadLocal<HashMap<Seq<String>, Validator>>(){

            public HashMap<Seq<String>, Validator> initialValue() {
                return new HashMap();
            }
        };
    }
}

