/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.unparsers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.processors.ElementRuntimeData;
import org.apache.daffodil.processors.unparsers.PackedBinaryBaseUnparser;
import org.apache.daffodil.processors.unparsers.UState;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3QAB\u0004\u0002\u0002IA\u0011b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u000f\t\u0011y\u0001!\u0011!Q\u0001\n}AQ!\n\u0001\u0005\u0002\u0019BQA\u000b\u0001\u0005B-BQ!\u000f\u0001\u0005Bi\u0012q\u0004U1dW\u0016$')\u001b8bef$UmY5nC2\u0014\u0015m]3V]B\f'o]3s\u0015\tA\u0011\"A\u0005v]B\f'o]3sg*\u0011!bC\u0001\u000baJ|7-Z:t_J\u001c(B\u0001\u0007\u000e\u0003!!\u0017M\u001a4pI&d'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u000f%\u0011ac\u0002\u0002\u0019!\u0006\u001c7.\u001a3CS:\f'/\u001f\"bg\u0016,f\u000e]1sg\u0016\u0014\u0018!A3\u0011\u0005eQR\"A\u0005\n\u0005mI!AE#mK6,g\u000e\u001e*v]RLW.\u001a#bi\u0006L!!H\u000b\u0002\u000f\r|g\u000e^3yi\u0006I\"-\u001b8bef$UmY5nC24\u0016N\u001d;vC2\u0004v.\u001b8u!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dB\u0013\u0006\u0005\u0002\u0015\u0001!)qc\u0001a\u00011!)ad\u0001a\u0001?\u0005qq-\u001a;Ok6\u0014WM\u001d+p!V$HC\u0001\u00175!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aAT;nE\u0016\u0014\b\"B\u001b\u0005\u0001\u00041\u0014AB;ti\u0006$X\r\u0005\u0002\u0015o%\u0011\u0001h\u0002\u0002\u0007+N#\u0018\r^3\u0002\u0013A,HOT;nE\u0016\u0014H#B\u001e?\r\"S\u0005C\u0001\u0011=\u0013\ti\u0014EA\u0004C_>dW-\u00198\t\u000b}*\u0001\u0019\u0001!\u0002\u0007\u0011|7\u000f\u0005\u0002B\t6\t!I\u0003\u0002D\u0017\u0005\u0011\u0011n\\\u0005\u0003\u000b\n\u0013\u0001\u0003R1uC>+H\u000f];u'R\u0014X-Y7\t\u000b\u001d+\u0001\u0019\u0001\u0017\u0002\r9,XNY3s\u0011\u0015IU\u00011\u0001 \u0003\u0015q')\u001b;t\u0011\u0015YU\u00011\u0001M\u0003\u00151\u0017N\u001c4p!\t\tU*\u0003\u0002O\u0005\nQai\u001c:nCRLeNZ8")
public abstract class PackedBinaryDecimalBaseUnparser
extends PackedBinaryBaseUnparser {
    private final int binaryDecimalVirtualPoint;

    @Override
    public Number getNumberToPut(UState ustate) {
        Number number = super.getNumberToPut(ustate);
        BigDecimal bigDec = (BigDecimal)number;
        if (bigDec.movePointRight(this.binaryDecimalVirtualPoint).scale() != 0) {
            throw super.context().schemaDefinitionError("Decimal point of number '%s' does not match the binaryVirtualDecmialPoint: %d", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bigDec, BoxesRunTime.boxToInteger((int)this.binaryDecimalVirtualPoint)}));
        }
        return bigDec.unscaledValue();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number number, int nBits, FormatInfo finfo) {
        byte[] packedNum = this.fromBigInteger((BigInteger)number, nBits);
        return dos.putByteArray(packedNum, (long)(packedNum.length * 8), finfo, dos.putByteArray$default$4());
    }

    public PackedBinaryDecimalBaseUnparser(ElementRuntimeData e, int binaryDecimalVirtualPoint) {
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        super(e);
    }
}

