/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.provider;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.deltaspike.core.api.provider.BeanManagerHolder;
import org.apache.deltaspike.core.api.provider.RootBeanManagerHolder;
import org.apache.deltaspike.core.api.provider.TestBeanManagerHolder;
import org.apache.deltaspike.core.util.ClassUtils;

public class BeanManagerProvider
implements Extension {
    private static Boolean testMode;
    private static BeanManagerProvider bmp;
    private volatile Map<ClassLoader, BeanManagerHolder> bms = new ConcurrentHashMap<ClassLoader, BeanManagerHolder>();

    public static boolean isActive() {
        return bmp != null;
    }

    public static BeanManagerProvider getInstance() {
        if (bmp == null) {
            // empty if block
        }
        if (bmp == null) {
            throw new IllegalStateException("No " + BeanManagerProvider.class.getName() + " in place! " + "Please ensure that you configured the CDI implementation of your choice properly. " + "If your setup is correct, please clear all caches and compiled artifacts.");
        }
        return bmp;
    }

    public BeanManager getBeanManager() {
        BeanManager result;
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        BeanManagerHolder resultHolder = this.bms.get(classLoader);
        if (resultHolder == null) {
            result = this.resolveBeanManagerViaJndi();
            if (result != null) {
                this.bms.put(classLoader, new RootBeanManagerHolder(result));
            }
        } else {
            result = resultHolder.getBeanManager();
            if (!(resultHolder instanceof RootBeanManagerHolder)) {
                BeanManager jndiBeanManager = this.resolveBeanManagerViaJndi();
                if (jndiBeanManager != null && jndiBeanManager != result) {
                    this.setRootBeanManager(jndiBeanManager);
                    result = jndiBeanManager;
                } else {
                    this.setRootBeanManager(result);
                }
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unable to find BeanManager. Please ensure that you configured the CDI implementation of your choice properly.");
        }
        return result;
    }

    protected void setBeanManager(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.setBeanManager(new BeanManagerHolder(beanManager));
    }

    public void setRootBeanManager(BeanManager beanManager) {
        this.setBeanManager(new RootBeanManagerHolder(beanManager));
    }

    private void setBeanManager(BeanManagerHolder beanManagerHolder) {
        BeanManagerProvider bmpFirst = BeanManagerProvider.setBeanManagerProvider(this);
        ClassLoader cl = ClassUtils.getClassLoader(null);
        if (beanManagerHolder instanceof RootBeanManagerHolder || !(bmpFirst.bms.get(cl) instanceof RootBeanManagerHolder)) {
            bmpFirst.bms.put(cl, beanManagerHolder);
        }
        if (Boolean.TRUE.equals(testMode)) {
            bmpFirst.bms.put(cl, new TestBeanManagerHolder(beanManagerHolder.getBeanManager()));
        }
    }

    public void cleanupStoredBeanManagerOnShutdown(@Observes BeforeShutdown beforeShutdown) {
        this.bms.remove(ClassUtils.getClassLoader(null));
    }

    BeanManager resolveBeanManagerViaJndi() {
        try {
            return (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            return null;
        }
    }

    private static BeanManagerProvider setBeanManagerProvider(BeanManagerProvider beanManagerProvider) {
        if (bmp == null) {
            bmp = beanManagerProvider;
        }
        return bmp;
    }

    protected void setTestMode() {
        BeanManagerProvider.activateTestMode();
    }

    private static void activateTestMode() {
        testMode = true;
    }

    static {
        bmp = null;
    }
}

