/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.util.metadata.builder.ImmutableInjectionPoint;

@Typed
public abstract class BeanUtils {
    private BeanUtils() {
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Annotation[] ... annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        Annotation[][] arr$ = annotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = arr$[i$]) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    public static <X> List<InjectionPoint> createInjectionPoints(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (AnnotatedParameter parameter : method.getParameters()) {
            ImmutableInjectionPoint injectionPoint = new ImmutableInjectionPoint(parameter, beanManager, declaringBean, false, false);
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

