/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.inject.Typed;

@Typed
public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static ClassLoader getClassLoader(Object o) {
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return Thread.currentThread().getContextClassLoader();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (loader == null && o != null) {
            loader = o.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        return loader;
    }

    public static <T> Class<T> tryToLoadClassForName(String name, Class<T> targetType) {
        return ClassUtils.tryToLoadClassForName(name);
    }

    public static Class tryToLoadClassForName(String name) {
        try {
            return ClassUtils.loadClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, ClassUtils.getClassLoader(null));
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(name, false, ClassUtils.class.getClassLoader());
        }
    }

    public static <T> T tryToInstantiateClass(Class<T> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T tryToInstantiateClassForName(String className, Class<T> targetType) {
        Object result = ClassUtils.tryToInstantiateClassForName(className);
        return (T)(result != null ? result : null);
    }

    public static Object tryToInstantiateClassForName(String className) {
        try {
            return ClassUtils.instantiateClassForName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object instantiateClassForName(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.loadClassForName(className).newInstance();
    }

    public static String getJarVersion(Class targetClass) {
        String manifestFileLocation = ClassUtils.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRevision(Class targetClass) {
        String manifestFileLocation = ClassUtils.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue("Revision");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getManifestFileLocationOfClass(Class targetClass) {
        String manifestFileLocation;
        try {
            manifestFileLocation = ClassUtils.getManifestLocation(targetClass);
        }
        catch (Exception e) {
            manifestFileLocation = ClassUtils.getManifestLocation(targetClass.getSuperclass());
        }
        return manifestFileLocation;
    }

    private static String getManifestLocation(Class targetClass) {
        String classFilePath = targetClass.getCanonicalName().replace('.', '/') + ".class";
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        String classLocation = targetClass.getResource(targetClass.getSimpleName() + ".class").toString();
        return classLocation.substring(0, classLocation.indexOf(classFilePath) - 1) + manifestFilePath;
    }
}

