/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.api.projectstage.TestStage;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

@ApplicationScoped
public class ProjectStageProducer
implements Serializable {
    protected static final Logger LOG = Logger.getLogger(ProjectStageProducer.class.getName());
    private static final long serialVersionUID = -2987762608635612074L;
    private static ProjectStage projectStage;
    private static volatile ProjectStageProducer projectStageProducer;

    protected ProjectStageProducer() {
    }

    @Produces
    @Dependent
    @Default
    public ProjectStage getProjectStage() {
        if (projectStage == null) {
            ProjectStageProducer.getInstance();
        }
        return projectStage;
    }

    public static ProjectStageProducer getInstance() {
        if (projectStageProducer == null) {
            ProjectStageProducer.lazyInit();
        }
        if (projectStage == null) {
            projectStageProducer.initProjectStage();
        }
        return projectStageProducer;
    }

    private static synchronized void lazyInit() {
        if (projectStageProducer != null) {
            return;
        }
        projectStageProducer = new ProjectStageProducer();
        projectStageProducer.initProjectStage();
    }

    protected ProjectStage resolveProjectStage() {
        String stageName = ConfigResolver.getPropertyValue("org.apache.deltaspike.ProjectStage");
        if (stageName != null) {
            return ProjectStage.valueOf(stageName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initProjectStage() {
        Class<ProjectStageProducer> clazz = ProjectStageProducer.class;
        synchronized (ProjectStageProducer.class) {
            if (projectStage == null) {
                projectStage = this.resolveProjectStage();
                if (projectStage == null) {
                    projectStage = ProjectStage.Production;
                }
                if (TestStage.class.isAssignableFrom(projectStage.getClass())) {
                    new BeanManagerProvider(){

                        @Override
                        public void setTestMode() {
                            super.setTestMode();
                        }
                    }.setTestMode();
                }
                LOG.info("Computed the following DeltaSpike ProjectStage: " + projectStage);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void reset() {
        ProjectStageProducer.resetCache();
    }

    private static void resetCache() {
        projectStage = null;
        projectStageProducer = null;
    }

    public static void setProjectStage(ProjectStage ps) {
        projectStage = ps;
    }
}

