/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.SetAccessiblePrivilegedAction;

@Typed
public abstract class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(fields, c.getDeclaredFields());
        }
        return fields;
    }

    public static Field tryToFindDeclaredField(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static <X> AnnotatedField<? super X> getField(AnnotatedType<X> annotatedType, Field field) {
        for (AnnotatedField annotatedField : annotatedType.getFields()) {
            if (!annotatedField.getDeclaringType().getJavaClass().equals(field.getDeclaringClass()) || !annotatedField.getJavaMember().getName().equals(field.getName())) continue;
            return annotatedField;
        }
        return null;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(methods, c.getDeclaredMethods());
        }
        return methods;
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Details: Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append(i > 0 ? ", " : "").append(args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    @Deprecated
    public static <A extends AccessibleObject> A setAccessible(A member) {
        AccessController.doPrivileged(new SetAccessiblePrivilegedAction(member));
        return member;
    }

    public static <T> T invokeMethod(Object instance, Method method, Class<T> expectedReturnType, boolean setAccessible, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            ReflectionUtils.setAccessible(method);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (Exception e) {
            String customMessage = ReflectionUtils.createCustomMessage(e, method, instance, args);
            ExceptionUtils.changeAndThrowException(e, customMessage);
            return null;
        }
    }

    private static String createCustomMessage(Exception e, Method method, Object targetObject, Object ... arguments) {
        return e.getMessage() + ReflectionUtils.buildInvokeMethodErrorMessage(method, targetObject, arguments);
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null isn't supported");
        }
        return clazz.getTypeParameters();
    }

    public static Type[] getActualTypeArguments(Type type) {
        if (type instanceof Class) {
            return ReflectionUtils.getActualTypeArguments((Class)type);
        }
        throw new IllegalArgumentException((type != null ? type.getClass().getName() : "null") + " isn't supported");
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParameterizedTypeWithWildcard(Class<?> type) {
        if (ReflectionUtils.isParameterizedType(type)) {
            return ReflectionUtils.containsWildcards(type.getTypeParameters());
        }
        return false;
    }

    private static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Type type) {
        Class rawType = ReflectionUtils.getRawType(type);
        return rawType != null && rawType.isPrimitive();
    }
}

