/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.metadata;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class AnnotationInstanceProvider
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = -2345068201195886173L;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class<? extends Annotation> annotationClass;
    private final Map<String, ?> memberValues;

    private AnnotationInstanceProvider(Class<? extends Annotation> annotationClass, Map<String, ?> memberValues) {
        this.annotationClass = annotationClass;
        this.memberValues = memberValues;
    }

    public static <T extends Annotation> T of(Class<T> annotationClass, Map<String, ?> values) {
        if (values == null) {
            throw new IllegalArgumentException("Map of values must not be null");
        }
        String key = annotationClass.getName() + "_" + ((Object)values).hashCode();
        return (T)AnnotationInstanceProvider.initAnnotation(key, annotationClass, values);
    }

    public static <T extends Annotation> T of(Class<T> annotationClass) {
        return AnnotationInstanceProvider.of(annotationClass, Collections.EMPTY_MAP);
    }

    private static synchronized <T extends Annotation> Annotation initAnnotation(String key, Class<T> annotationClass, Map<String, ?> values) {
        return (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationInstanceProvider(annotationClass, values));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("equals".equals(method.getName())) {
            if (Proxy.isProxyClass(args[0].getClass()) && Proxy.getInvocationHandler(args[0]) instanceof AnnotationInstanceProvider) {
                return this.equals(Proxy.getInvocationHandler(args[0]));
            }
            return this.equals(args[0]);
        }
        if ("annotationType".equals(method.getName())) {
            return this.annotationType();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        if (this.memberValues.containsKey(method.getName())) {
            return this.memberValues.get(method.getName());
        }
        return method.getDefaultValue();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationClass;
    }

    @Override
    public String toString() {
        Method[] methods = this.annotationClass.getDeclaredMethods();
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        int length = methods.length;
        for (int i = 0; i < length; ++i) {
            Object memberValue;
            sb.append(methods[i].getName()).append("=");
            try {
                memberValue = this.invoke(this, methods[i], EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                memberValue = "";
            }
            sb.append(memberValue);
            if (i >= length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationInstanceProvider)) {
            if (this.annotationClass.isInstance(o)) {
                for (Map.Entry<String, ?> entry : this.memberValues.entrySet()) {
                    try {
                        Object oValue = this.annotationClass.getMethod(entry.getKey(), EMPTY_CLASS_ARRAY).invoke(o, EMPTY_OBJECT_ARRAY);
                        if (oValue != null && entry.getValue() != null) {
                            if (oValue.equals(entry.getValue())) continue;
                            return false;
                        }
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }
            return false;
        }
        AnnotationInstanceProvider that = (AnnotationInstanceProvider)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return ((Object)this.memberValues).equals(that.memberValues);
    }

    @Override
    public int hashCode() {
        int result = 0;
        Class<? extends Annotation> type = this.annotationClass;
        for (Method m : type.getDeclaredMethods()) {
            try {
                Object value = this.invoke(this, m, EMPTY_OBJECT_ARRAY);
                if (value == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", m));
                }
                result += this.hashMember(m.getName(), value);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private int hashMember(String name, Object value) {
        int part1 = name.hashCode() * 127;
        if (value.getClass().isArray()) {
            return part1 ^ AnnotationInstanceProvider.arrayMemberHash(value.getClass().getComponentType(), value);
        }
        if (value instanceof Annotation) {
            return part1 ^ this.hashCode((Annotation)value);
        }
        return part1 ^ value.hashCode();
    }

    private static int arrayMemberHash(Class<?> componentType, Object o) {
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])o);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])o);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])o);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])o);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])o);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])o);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])o);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])o);
        }
        return Arrays.hashCode((Object[])o);
    }

    private int hashCode(Annotation a) {
        int result = 0;
        Class<? extends Annotation> type = a.annotationType();
        for (Method m : type.getDeclaredMethods()) {
            try {
                Object value = m.invoke((Object)a, new Object[0]);
                if (value == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", m));
                }
                result += this.hashMember(m.getName(), value);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }
}

