/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.inject.Typed;

@Typed
public abstract class ServiceUtils {
    private ServiceUtils() {
    }

    public static <T> List<T> loadServiceImplementations(Class<T> serviceType) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> servicesIterator = ServiceLoader.load(serviceType).iterator();
        if (!servicesIterator.hasNext()) {
            ClassLoader fallbackClassLoader = ServiceUtils.class.getClassLoader();
            servicesIterator = ServiceLoader.load(serviceType, fallbackClassLoader).iterator();
        }
        while (servicesIterator.hasNext()) {
            result.add(servicesIterator.next());
        }
        return result;
    }
}

