/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.util.ProxyUtils;

@Typed
public abstract class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> T extractAnnotationFromMethodOrClass(BeanManager beanManager, Method targetMethod, Class<T> targetAnnotationType) {
        T result = AnnotationUtils.extractAnnotationFromMethod(beanManager, targetMethod, targetAnnotationType);
        if (result == null) {
            Class targetClass = ProxyUtils.getUnproxiedClass(targetMethod.getDeclaringClass());
            result = AnnotationUtils.findAnnotation(beanManager, targetClass.getAnnotations(), targetAnnotationType);
        }
        return result;
    }

    public static <T extends Annotation> T extractAnnotationFromMethod(BeanManager beanManager, Method targetMethod, Class<T> targetAnnotationType) {
        return AnnotationUtils.findAnnotation(beanManager, targetMethod.getAnnotations(), targetAnnotationType);
    }

    public static <T extends Annotation> T findAnnotation(BeanManager beanManager, Annotation[] annotations, Class<T> targetAnnotationType) {
        for (Annotation annotation : annotations) {
            T result;
            if (targetAnnotationType.equals(annotation.annotationType())) {
                return (T)annotation;
            }
            if (!beanManager.isStereotype(annotation.annotationType()) || (result = AnnotationUtils.findAnnotation(beanManager, annotation.annotationType().getAnnotations(), targetAnnotationType)) == null) continue;
            return result;
        }
        return null;
    }
}

