/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.resourceloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.resourceloader.InjectableResource;
import org.apache.deltaspike.core.api.resourceloader.InjectableResourceProvider;

public abstract class AbstractResourceProvider
implements InjectableResourceProvider {
    private static final Logger logger = Logger.getLogger(AbstractResourceProvider.class.getName());
    @Inject
    @Any
    private Instance<InjectionPoint> injectionPoint;

    protected boolean isXml(String fileName) {
        return fileName.endsWith(".xml");
    }

    protected InjectionPoint getInjectionPoint() {
        return (InjectionPoint)this.injectionPoint.get();
    }

    protected Set<Annotation> getAnnotations() {
        return this.getInjectionPoint().getAnnotated().getAnnotations();
    }

    protected void loadInputStreamToProperties(InputStream inputStream, Properties properties, String name) {
        boolean isXml = this.isXml(name);
        try {
            if (isXml) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read resource " + name, e);
        }
    }

    @Override
    public Properties readProperties(InjectableResource injectableResource) {
        Properties properties = new Properties();
        String name = injectableResource.location();
        InputStream inputStream = this.readStream(injectableResource);
        this.loadInputStreamToProperties(inputStream, properties, name);
        return properties;
    }

    @Override
    public List<InputStream> readStreams(InjectableResource injectableResource) {
        return Collections.singletonList(this.readStream(injectableResource));
    }
}

