/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.Nonbinding;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;

@Typed
public abstract class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> T extractAnnotationFromMethodOrClass(BeanManager beanManager, Method targetMethod, Class targetClass, Class<T> targetAnnotationType) {
        T result = AnnotationUtils.extractAnnotationFromMethod(beanManager, targetMethod, targetAnnotationType);
        if (result == null) {
            Class unproxiedTargetClass = ProxyUtils.getUnproxiedClass(targetClass);
            result = AnnotationUtils.findAnnotation(beanManager, unproxiedTargetClass.getAnnotations(), targetAnnotationType);
        }
        return result;
    }

    public static <T extends Annotation> T extractAnnotationFromMethod(BeanManager beanManager, Method targetMethod, Class<T> targetAnnotationType) {
        return AnnotationUtils.findAnnotation(beanManager, targetMethod.getAnnotations(), targetAnnotationType);
    }

    public static <T extends Annotation> T findAnnotation(BeanManager beanManager, Annotation[] annotations, Class<T> targetAnnotationType) {
        for (Annotation annotation : annotations) {
            T result;
            if (targetAnnotationType.equals(annotation.annotationType())) {
                return (T)annotation;
            }
            if (!beanManager.isStereotype(annotation.annotationType()) || (result = AnnotationUtils.findAnnotation(beanManager, annotation.annotationType().getAnnotations(), targetAnnotationType)) == null) continue;
            return result;
        }
        return null;
    }

    public static int getQualifierHashCode(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        int hashCode = AnnotationUtils.getTypeHashCode(annotationClass);
        for (Method member : annotationClass.getDeclaredMethods()) {
            Class<?> annotationMemberType;
            if (member.isAnnotationPresent(Nonbinding.class)) continue;
            Object annotationMemberValue = ReflectionUtils.invokeMethod(annotation, member, Object.class, true, new Object[0]);
            int arrayValue = annotationMemberValue.getClass().isArray() ? ((annotationMemberType = annotationMemberValue.getClass().getComponentType()).isPrimitive() ? (Long.TYPE == annotationMemberType ? Arrays.hashCode((long[])annotationMemberValue) : (Integer.TYPE == annotationMemberType ? Arrays.hashCode((int[])annotationMemberValue) : (Short.TYPE == annotationMemberType ? Arrays.hashCode((short[])annotationMemberValue) : (Double.TYPE == annotationMemberType ? Arrays.hashCode((double[])annotationMemberValue) : (Float.TYPE == annotationMemberType ? Arrays.hashCode((float[])annotationMemberValue) : (Boolean.TYPE == annotationMemberType ? Arrays.hashCode((boolean[])annotationMemberValue) : (Byte.TYPE == annotationMemberType ? Arrays.hashCode((byte[])annotationMemberValue) : (Character.TYPE == annotationMemberType ? Arrays.hashCode((char[])annotationMemberValue) : 0)))))))) : Arrays.hashCode((Object[])annotationMemberValue)) : annotationMemberValue.hashCode();
            hashCode = 29 * hashCode + arrayValue;
            hashCode = 29 * hashCode + member.getName().hashCode();
        }
        return hashCode;
    }

    private static int getTypeHashCode(Type type) {
        int typeHash = type.hashCode();
        if (typeHash == 0 && type instanceof Class) {
            return ((Class)type).getName().hashCode();
        }
        return typeHash;
    }
}

