/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;
import org.apache.deltaspike.core.util.ClassUtils;

public final class ParentExtensionStorage {
    private static Set<ExtensionStorageInfo> extensionStorage = new HashSet<ExtensionStorageInfo>();

    private ParentExtensionStorage() {
    }

    public static synchronized void addExtension(Extension extension) {
        if (ParentExtensionStorage.usingParentExtension()) {
            ParentExtensionStorage.removeAbandonedExtensions();
            ClassLoader classLoader = ClassUtils.getClassLoader(null);
            extensionStorage.add(new ExtensionStorageInfo(classLoader, extension));
        }
    }

    private static boolean usingParentExtension() {
        return CoreBaseConfig.ParentExtensionCustomization.PARENT_EXTENSION_ENABLED;
    }

    private static void removeAbandonedExtensions() {
        Iterator<ExtensionStorageInfo> it = extensionStorage.iterator();
        while (it.hasNext()) {
            ExtensionStorageInfo info = it.next();
            if (!info.isAbandoned()) continue;
            it.remove();
        }
    }

    public static synchronized <T extends Extension> T getParentExtension(Extension extension) {
        if (ParentExtensionStorage.usingParentExtension()) {
            ClassLoader parentClassLoader = ClassUtils.getClassLoader(null).getParent();
            for (ExtensionStorageInfo extensionInfo : extensionStorage) {
                if (extensionInfo.isAbandoned() || !extension.getClass().equals(extensionInfo.getExtension().getClass()) || !extensionInfo.getClassLoader().equals(parentClassLoader)) continue;
                return (T)extensionInfo.getExtension();
            }
        }
        return null;
    }

    private static class ExtensionStorageInfo {
        private final WeakReference<ClassLoader> classLoader;
        private final WeakReference<Extension> extension;

        public ExtensionStorageInfo(ClassLoader classLoader, Extension extension) {
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.extension = new WeakReference<Extension>(extension);
        }

        boolean isAbandoned() {
            return this.classLoader.get() == null || this.extension.get() == null;
        }

        ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoader.get();
        }

        Extension getExtension() {
            return (Extension)this.extension.get();
        }
    }
}

