/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.provider;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.core.util.ProjectStageProducer;

@Typed
public final class BeanProvider {
    private static final Logger LOG = Logger.getLogger(BeanProvider.class.getName());
    private static final boolean LOG_DEPENDENT_WARNINGS = Arrays.asList(ProjectStage.Development, ProjectStage.UnitTest).contains(ProjectStageProducer.getInstance().getProjectStage());

    private BeanProvider() {
    }

    public static <T> T getContextualReference(Class<T> type, Annotation ... qualifiers) {
        return BeanProvider.getContextualReference(type, false, qualifiers);
    }

    public static <T> T getContextualReference(Class<T> type, boolean optional, Annotation ... qualifiers) {
        BeanManager beanManager = BeanProvider.getBeanManager();
        return BeanProvider.getContextualReference(beanManager, type, optional, qualifiers);
    }

    public static <T> T getContextualReference(BeanManager beanManager, Class<T> type, boolean optional, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(type, qualifiers);
        if (beans == null || beans.isEmpty()) {
            if (optional) {
                return null;
            }
            throw new IllegalStateException("Could not find beans for Type=" + type + " and qualifiers:" + Arrays.toString(qualifiers));
        }
        return BeanProvider.getContextualReference(type, beanManager, beans);
    }

    public static Object getContextualReference(String name) {
        return BeanProvider.getContextualReference(name, false);
    }

    public static Object getContextualReference(String name, boolean optional) {
        return BeanProvider.getContextualReference(name, optional, Object.class);
    }

    public static <T> T getContextualReference(String name, boolean optional, Class<T> type) {
        return BeanProvider.getContextualReference(BeanProvider.getBeanManager(), name, optional, type);
    }

    public static <T> T getContextualReference(BeanManager beanManager, String name, boolean optional, Class<T> type) {
        Set beans = beanManager.getBeans(name);
        if (beans == null || beans.isEmpty()) {
            if (optional) {
                return null;
            }
            throw new IllegalStateException("Could not find beans for Type=" + type + " and name:" + name);
        }
        return BeanProvider.getContextualReference(type, beanManager, beans);
    }

    public static <T> T getContextualReference(Class<T> type, Bean<T> bean) {
        return BeanProvider.getContextualReference(type, BeanProvider.getBeanManager(), bean);
    }

    private static <T> T getContextualReference(Class<T> type, BeanManager beanManager, Bean<?> bean) {
        return BeanProvider.getContextualReference(type, beanManager, Collections.singleton(bean));
    }

    public static <T> List<T> getContextualReferences(Class<T> type, boolean optional) {
        return BeanProvider.getContextualReferences(type, optional, true);
    }

    public static <T> List<T> getContextualReferences(Class<T> type, boolean optional, boolean includeDefaultScopedBeans) {
        BeanManager beanManager = BeanProvider.getBeanManager();
        Set<Bean<T>> beans = BeanProvider.getBeanDefinitions(type, optional, includeDefaultScopedBeans, beanManager);
        ArrayList<T> result = new ArrayList<T>(beans.size());
        for (Bean<T> bean : beans) {
            result.add(BeanProvider.getContextualReference(type, beanManager, bean));
        }
        return result;
    }

    public static <T> DependentProvider<T> getDependent(Class<T> type, Annotation ... qualifiers) {
        BeanManager beanManager = BeanProvider.getBeanManager();
        return BeanProvider.getDependent(beanManager, type, qualifiers);
    }

    public static <T> DependentProvider<T> getDependent(BeanManager beanManager, Class<T> type, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(type, qualifiers);
        Bean bean = beanManager.resolve(beans);
        return BeanProvider.createDependentProvider(beanManager, type, bean);
    }

    public static <T> DependentProvider<T> getDependent(String name) {
        BeanManager beanManager = BeanProvider.getBeanManager();
        return BeanProvider.getDependent(beanManager, name);
    }

    public static <T> DependentProvider<T> getDependent(BeanManager beanManager, String name) {
        Set beans = beanManager.getBeans(name);
        Bean bean = beanManager.resolve(beans);
        Class beanClass = bean.getBeanClass();
        return BeanProvider.createDependentProvider(beanManager, beanClass, bean);
    }

    private static <T> DependentProvider<T> createDependentProvider(BeanManager beanManager, Class<T> type, Bean<T> bean) {
        CreationalContext cc = beanManager.createCreationalContext(bean);
        Object instance = beanManager.getReference(bean, type, cc);
        return new DependentProvider<Object>(bean, cc, instance);
    }

    public static <T> Set<Bean<T>> getBeanDefinitions(Class<T> type, boolean optional, boolean includeDefaultScopedBeans) {
        BeanManager beanManager = BeanProvider.getBeanManager();
        return BeanProvider.getBeanDefinitions(type, optional, includeDefaultScopedBeans, beanManager);
    }

    private static <T> Set<Bean<T>> getBeanDefinitions(Class<T> type, boolean optional, boolean includeDefaultScopedBeans, BeanManager beanManager) {
        Set<Bean<?>> beans = beanManager.getBeans(type, new Annotation[]{new AnyLiteral()});
        if (beans == null || beans.isEmpty()) {
            if (optional) {
                return Collections.emptySet();
            }
            throw new IllegalStateException("Could not find beans for Type=" + type);
        }
        if (!includeDefaultScopedBeans) {
            beans = BeanProvider.filterDefaultScopedBeans(beans);
        }
        HashSet<Bean<T>> result = new HashSet<Bean<T>>();
        Iterator<Bean<?>> iterator = beans.iterator();
        while (iterator.hasNext()) {
            Bean<?> bean;
            Bean<?> beanT = bean = iterator.next();
            result.add(beanT);
        }
        return result;
    }

    public static <T> T injectFields(T instance) {
        if (instance == null) {
            return null;
        }
        BeanManager beanManager = BeanProvider.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        injectionTarget.inject(instance, creationalContext);
        return instance;
    }

    private static Set<Bean<?>> filterDefaultScopedBeans(Set<Bean<?>> beans) {
        HashSet result = new HashSet(beans.size());
        for (Bean<?> currentBean : beans) {
            if (Dependent.class.isAssignableFrom(currentBean.getScope())) continue;
            result.add(currentBean);
        }
        return result;
    }

    private static <T> T getContextualReference(Class<T> type, BeanManager beanManager, Set<Bean<?>> beans) {
        Bean bean = beanManager.resolve(beans);
        BeanProvider.logWarningIfDependent(bean);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, type, creationalContext);
        return (T)result;
    }

    private static void logWarningIfDependent(Bean<?> bean) {
        if (LOG_DEPENDENT_WARNINGS && bean.getScope().equals(Dependent.class)) {
            LOG.log(Level.WARNING, "BeanProvider shall not be used to create @Dependent scoped beans. Bean: " + bean.toString());
        }
    }

    private static BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }
}

