/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.inject.Typed;

@Typed
public abstract class OptionalUtil {
    private static boolean optionalSupported = true;
    private static Class<?> optionalClass;
    private static Method optionalMethod;

    public static boolean isOptionalSupported() {
        return optionalSupported;
    }

    public static boolean isOptionalReturned(Method method) {
        return optionalSupported && optionalClass.isAssignableFrom(method.getReturnType());
    }

    public static Object wrap(Object input) {
        if (!optionalSupported) {
            return input;
        }
        try {
            return optionalMethod.invoke(null, input);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            optionalClass = Class.forName("java.util.Optional");
            optionalMethod = optionalClass.getMethod("ofNullable", Object.class);
        }
        catch (Exception e) {
            optionalSupported = false;
            optionalClass = null;
            optionalMethod = null;
        }
    }
}

