/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.util.ClassUtils;

@Typed
public abstract class PropertyFileUtils {
    private PropertyFileUtils() {
    }

    public static Enumeration<URL> resolvePropertyFiles(String propertyFileName) throws IOException {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        Enumeration<URL> propertyFileUrls = cl.getResources(propertyFileName);
        if (!propertyFileUrls.hasMoreElements()) {
            cl = PropertyFileUtils.class.getClassLoader();
            propertyFileUrls = cl.getResources(propertyFileName);
        }
        return propertyFileUrls;
    }

    public static Properties loadProperties(URL url) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            if (inputStream != null) {
                props.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public static ResourceBundle getResourceBundle(String bundleName) {
        return PropertyFileUtils.getResourceBundle(bundleName, Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, ClassUtils.getClassLoader(null));
    }
}

