/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.enterprise.inject.Typed;

@Typed
public abstract class StreamUtil {
    private static boolean streamSupported = true;
    private static Class<?> streamClass;
    private static Method streamMethod;

    public static boolean isStreamSupported() {
        return streamSupported;
    }

    public static boolean isStreamReturned(Method method) {
        return StreamUtil.isStreamSupported() && streamClass.isAssignableFrom(method.getReturnType());
    }

    public static Object wrap(Object input) {
        if (!StreamUtil.isStreamSupported() || input == null) {
            return input;
        }
        try {
            return streamMethod.invoke(input, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            streamClass = Class.forName("java.util.stream.Stream");
            streamMethod = Collection.class.getMethod("stream", new Class[0]);
        }
        catch (Exception e) {
            streamSupported = false;
            streamClass = null;
            streamMethod = null;
        }
    }
}

