/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.provider;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;
import org.apache.deltaspike.core.util.ClassUtils;

public class BeanManagerProvider
implements Extension {
    private static final Logger LOG = Logger.getLogger(BeanManagerProvider.class.getName());
    private static final Method CDI_CURRENT_METHOD;
    private static final Method CDI_CURRENT_BEAN_MANAGER_METHOD;
    private static BeanManagerProvider bmpSingleton;
    private volatile Map<ClassLoader, BeanManagerInfo> bmInfos = new ConcurrentHashMap<ClassLoader, BeanManagerInfo>();

    public static boolean isActive() {
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            return bmpSingleton != null;
        }
        return bmpSingleton != null && BeanManagerProvider.bmpSingleton.bmInfos.containsKey(ClassUtils.getClassLoader(null));
    }

    public static BeanManagerProvider getInstance() {
        if (bmpSingleton == null) {
            throw new IllegalStateException("No " + BeanManagerProvider.class.getName() + " in place! Please ensure that you configured the CDI implementation of your choice properly. If your setup is correct, please clear all caches and compiled artifacts.");
        }
        return bmpSingleton;
    }

    public void setBeanManager(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        BeanManagerProvider.setBeanManagerProvider(this);
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            return;
        }
        BeanManagerInfo bmi = this.getBeanManagerInfo(ClassUtils.getClassLoader(null));
        bmi.loadTimeBm = beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanManager getBeanManager() {
        BeanManager result;
        BeanManagerInfo parentBmi;
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            return this.resolveBeanManagerViaStaticHelper();
        }
        BeanManagerInfo bmi = this.getBeanManagerInfo(ClassUtils.getClassLoader(null));
        if (!bmi.booted && bmi.loadTimeBm == null && (parentBmi = this.getParentBeanManagerInfo(ClassUtils.getClassLoader(null))) != null) {
            bmi.loadTimeBm = parentBmi.loadTimeBm;
        }
        if ((result = bmi.finalBm) == null) {
            BeanManagerInfo beanManagerInfo = bmi;
            synchronized (beanManagerInfo) {
                result = bmi.finalBm;
                if (result == null) {
                    result = this.resolveBeanManagerViaJndi();
                    if (result == null) {
                        result = bmi.loadTimeBm;
                    }
                    if (result == null) {
                        throw new IllegalStateException("Unable to find BeanManager. Please ensure that you configured the CDI implementation of your choice properly.");
                    }
                    bmi.finalBm = result;
                }
            }
        }
        return result;
    }

    public void cleanupFinalBeanManagers(@Observes AfterDeploymentValidation adv) {
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            return;
        }
        for (BeanManagerInfo bmi : BeanManagerProvider.bmpSingleton.bmInfos.values()) {
            bmi.finalBm = null;
            bmi.booted = true;
        }
    }

    public void cleanupStoredBeanManagerOnShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            return;
        }
        if (bmpSingleton == null) {
            return;
        }
        BeanManagerProvider.bmpSingleton.bmInfos.remove(ClassUtils.getClassLoader(null));
    }

    private BeanManager resolveBeanManagerViaJndi() {
        try {
            return (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            return null;
        }
    }

    private BeanManager resolveBeanManagerViaStaticHelper() {
        if (CDI_CURRENT_METHOD != null && CDI_CURRENT_BEAN_MANAGER_METHOD != null) {
            try {
                Object cdiCurrentObject = CDI_CURRENT_METHOD.invoke(null, new Object[0]);
                return (BeanManager)CDI_CURRENT_BEAN_MANAGER_METHOD.invoke(cdiCurrentObject, new Object[0]);
            }
            catch (Throwable t) {
                LOG.log(Level.FINEST, "failed to delegate bean-manager lookup -> fallback to default.", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManagerInfo getBeanManagerInfo(ClassLoader cl) {
        BeanManagerInfo bmi = BeanManagerProvider.bmpSingleton.bmInfos.get(cl);
        if (bmi == null) {
            BeanManagerProvider beanManagerProvider = this;
            synchronized (beanManagerProvider) {
                bmi = BeanManagerProvider.bmpSingleton.bmInfos.get(cl);
                if (bmi == null) {
                    bmi = new BeanManagerInfo();
                    BeanManagerProvider.bmpSingleton.bmInfos.put(cl, bmi);
                    if (cl.getParent() != null && !BeanManagerProvider.bmpSingleton.bmInfos.containsKey(cl.getParent())) {
                        BeanManagerProvider.bmpSingleton.bmInfos.put(cl.getParent(), bmi);
                    }
                }
            }
        }
        return bmi;
    }

    private static BeanManagerProvider setBeanManagerProvider(BeanManagerProvider beanManagerProvider) {
        if (bmpSingleton == null) {
            bmpSingleton = beanManagerProvider;
        }
        return bmpSingleton;
    }

    private BeanManagerInfo getParentBeanManagerInfo(ClassLoader classLoader) {
        ClassLoader parentClassLoader = classLoader.getParent();
        if (parentClassLoader == null) {
            return null;
        }
        BeanManagerInfo bmi = this.getBeanManagerInfo(parentClassLoader);
        if (bmi == null) {
            bmi = this.getParentBeanManagerInfo(parentClassLoader);
        }
        return bmi;
    }

    static {
        Class cdiClass = ClassUtils.tryToLoadClassForName("javax.enterprise.inject.spi.CDI");
        Method resolvedCdiCurrentMethod = null;
        Method resolvedCdiBeanManagerMethod = null;
        if (cdiClass != null && CoreBaseConfig.BeanManagerIntegration.DELEGATE_LOOKUP.booleanValue()) {
            try {
                resolvedCdiCurrentMethod = cdiClass.getDeclaredMethod("current", new Class[0]);
                resolvedCdiBeanManagerMethod = cdiClass.getDeclaredMethod("getBeanManager", new Class[0]);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Couldn't get method from " + cdiClass.getName(), e);
            }
        }
        CDI_CURRENT_METHOD = resolvedCdiCurrentMethod;
        CDI_CURRENT_BEAN_MANAGER_METHOD = resolvedCdiBeanManagerMethod;
    }

    private static class BeanManagerInfo {
        private BeanManager loadTimeBm;
        private BeanManager finalBm;
        private boolean booted;

        private BeanManagerInfo() {
        }
    }
}

