/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.spi.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.BeanUtils;

public abstract class BaseConfigPropertyProducer {
    protected String getStringPropertyValue(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        return this.getPropertyValue(injectionPoint, String.class);
    }

    protected <T> T getPropertyValue(InjectionPoint injectionPoint, Class<T> ipCls) {
        return this.getUntypedPropertyValue(injectionPoint, ipCls);
    }

    protected <T> T getUntypedPropertyValue(InjectionPoint injectionPoint, Type ipCls) {
        ConfigProperty configProperty = this.getAnnotation(injectionPoint, ConfigProperty.class);
        if (configProperty == null) {
            throw new IllegalStateException("producer method called without @ConfigProperty being present!");
        }
        return this.readEntry(configProperty.name(), configProperty.defaultValue(), ipCls, configProperty.converter(), configProperty.parameterizedBy(), configProperty.projectStageAware(), configProperty.evaluateVariables());
    }

    protected String getPropertyValue(String propertyName, String defaultValue) {
        String configuredValue = "org.apache.deltaspike.NullValueMarker".equals(defaultValue) ? ConfigResolver.getProjectStageAwarePropertyValue(propertyName) : ConfigResolver.getProjectStageAwarePropertyValue(propertyName, defaultValue);
        return configuredValue;
    }

    protected <T extends Annotation> T getAnnotation(InjectionPoint injectionPoint, Class<T> targetType) {
        return BeanUtils.extractAnnotation(injectionPoint.getAnnotated(), targetType);
    }

    public <T> T readEntry(String key, String stringDefault, Type ipCls, Class<? extends ConfigResolver.Converter> converterType, String parameterizedBy, boolean projectStageAware, boolean evaluate) {
        ConfigResolver.TypedResolver<T> resolver = this.asResolver(key, stringDefault, ipCls, converterType, parameterizedBy, projectStageAware, evaluate);
        return resolver.getValue();
    }

    public <T> ConfigResolver.TypedResolver<T> asResolver(String key, String stringDefault, Type ipCls, Class<? extends ConfigResolver.Converter> converterType, String parameterizedBy, boolean projectStageAware, boolean evaluate) {
        ConfigResolver.UntypedResolver<String> untypedResolver = ConfigResolver.resolve(key);
        ConfigResolver.TypedResolver resolver = (ConfigResolver.Converter.class == converterType ? untypedResolver.as((Class)Class.class.cast(ipCls)) : untypedResolver.as(ipCls, BeanProvider.getContextualReference(converterType, new Annotation[0]))).withCurrentProjectStage(projectStageAware);
        if (!"org.apache.deltaspike.NullValueMarker".equals(stringDefault)) {
            resolver.withStringDefault(stringDefault);
        }
        if (!"org.apache.deltaspike.NullValueMarker".equals(parameterizedBy)) {
            resolver.parameterizedBy(parameterizedBy);
        }
        return resolver.evaluateVariables(evaluate);
    }
}

