/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.deltaspike.core.impl.config.EnvironmentPropertyConfigSource;
import org.apache.deltaspike.core.impl.config.LocalJndiConfigSource;
import org.apache.deltaspike.core.impl.config.PropertyFileConfigSource;
import org.apache.deltaspike.core.impl.config.SystemPropertyConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.PropertyFileUtils;

public class DefaultConfigSourceProvider
implements ConfigSourceProvider {
    private static final String PROPERTY_FILE_NAME = "META-INF/apache-deltaspike.properties";
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();

    public DefaultConfigSourceProvider() {
        this.configSources.add(new SystemPropertyConfigSource());
        this.configSources.add(new EnvironmentPropertyConfigSource());
        this.configSources.add(new LocalJndiConfigSource());
        try {
            Enumeration propertyFileUrls = PropertyFileUtils.resolvePropertyFiles((String)PROPERTY_FILE_NAME);
            while (propertyFileUrls.hasMoreElements()) {
                URL propertyFileUrl = (URL)propertyFileUrls.nextElement();
                this.configSources.add(new PropertyFileConfigSource(propertyFileUrl));
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("problem while loading DeltaSpike property files", ioe);
        }
    }

    public List<ConfigSource> getConfigSources() {
        return this.configSources;
    }
}

