/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.impl.config.BaseConfigSource;
import org.apache.deltaspike.core.impl.util.JndiUtils;

@Typed
class LocalJndiConfigSource
extends BaseConfigSource {
    private static final String BASE_NAME = "java:comp/env/deltaspike/";

    public LocalJndiConfigSource() {
        this.initOrdinal(200);
    }

    public String getPropertyValue(String key) {
        try {
            String jndiKey = key.startsWith("java:comp/env") ? key : BASE_NAME + key;
            return JndiUtils.lookup(jndiKey, String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getConfigName() {
        return BASE_NAME;
    }
}

