/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config.injectable;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.annotation.ConfigProperty;
import org.apache.deltaspike.core.api.converter.Converter;
import org.apache.deltaspike.core.api.converter.MetaDataAwareConverter;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.converter.ConverterFactory;
import org.apache.deltaspike.core.util.ClassUtils;

public class ConfigPropertyBean<T>
implements Bean<T>,
Serializable {
    private static final long serialVersionUID = 219378243102320371L;
    private final Class<?> beanType;
    private final Set<Annotation> qualifiers;
    private final Set<Type> types;
    private final ConfigProperty configProperty;
    private final Annotation customQualifier;

    public ConfigPropertyBean(Type targetType, ConfigProperty configProperty, Annotation customQualifier) {
        this.configProperty = configProperty;
        this.qualifiers = new HashSet<Annotation>();
        if (customQualifier != null) {
            this.qualifiers.add(customQualifier);
        } else {
            this.qualifiers.add((Annotation)configProperty);
        }
        this.customQualifier = customQualifier;
        this.beanType = (Class)targetType;
        this.types = new HashSet<Type>();
        this.types.add(this.beanType);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this.beanType;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public T create(CreationalContext<T> creationalContext) {
        Converter converter;
        ConverterFactory converterFactory = (ConverterFactory)BeanProvider.getContextualReference(ConverterFactory.class, (boolean)false, (Annotation[])new Annotation[0]);
        String configuredValue = ConfigResolver.getPropertyValue((String)this.configProperty.name());
        if (Converter.class.equals((Object)this.configProperty.converter())) {
            converter = converterFactory.create(String.class, this.beanType, this.customQualifier != null ? this.customQualifier.annotationType() : null);
        } else {
            converter = (Converter)BeanProvider.getContextualReference((Class)this.configProperty.converter(), (boolean)true, (Annotation[])new Annotation[0]);
            if (converter == null) {
                converter = (Converter)ClassUtils.tryToInstantiateClass((Class)this.configProperty.converter());
            }
        }
        if (converter == null) {
            throw new IllegalStateException("can't find config for " + String.class.getName() + " -> " + this.beanType.getName());
        }
        if (this.customQualifier != null && converter instanceof MetaDataAwareConverter) {
            return (T)((MetaDataAwareConverter)converter).convert((Object)configuredValue, (Object)this.customQualifier);
        }
        return (T)converter.convert((Object)configuredValue);
    }

    public void destroy(T configPropertyProducer, CreationalContext<T> configPropertyProducerCreationalContext) {
    }
}

