/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config.injectable.extension;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.annotation.ConfigProperty;
import org.apache.deltaspike.core.impl.config.injectable.ConfigPropertyBean;
import org.apache.deltaspike.core.impl.config.injectable.extension.InjectionTargetEntry;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class ConfigPropertyExtension
implements Extension,
Deactivatable {
    private Boolean isActivated = null;
    private Set<InjectionTargetEntry> injectionTargets = new HashSet<InjectionTargetEntry>();

    protected void recordConfigPropertyAwareInjectionPoint(@Observes ProcessInjectionTarget event) {
        this.initActivation();
        if (!this.isActivated.booleanValue()) {
            return;
        }
        InjectionTarget injectionTarget = event.getInjectionTarget();
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            Annotation qualifier = null;
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            if (configProperty == null) {
                for (Annotation annotation : injectionPoint.getAnnotated().getAnnotations()) {
                    configProperty = annotation.annotationType().getAnnotation(ConfigProperty.class);
                    if (configProperty == null) continue;
                    qualifier = annotation;
                    break;
                }
            }
            if (configProperty == null) continue;
            if (configProperty.eager() && ConfigResolver.getPropertyValue((String)configProperty.name()) == null) {
                throw new IllegalStateException("no configured value found for property: " + configProperty.name());
            }
            this.injectionTargets.add(new InjectionTargetEntry(injectionPoint.getType(), configProperty, qualifier));
        }
    }

    protected void addDependentBeans(@Observes AfterBeanDiscovery event) {
        this.initActivation();
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (InjectionTargetEntry injectionTargetEntry : this.injectionTargets) {
            event.addBean(new ConfigPropertyBean(injectionTargetEntry.getType(), injectionTargetEntry.getConfigProperty(), injectionTargetEntry.getCustomQualifier()));
        }
    }

    protected void initActivation() {
        if (this.isActivated == null) {
            this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        }
    }
}

