/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.converter.Converter;
import org.apache.deltaspike.core.api.converter.MetaDataAwareConverter;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.impl.converter.ConverterKey;
import org.apache.deltaspike.core.impl.converter.StringToIntegerConverter;
import org.apache.deltaspike.core.impl.converter.StringToLongConverter;
import org.apache.deltaspike.core.spi.converter.ConverterFactory;

@ApplicationScoped
public class DefaultConverterFactory
implements ConverterFactory {
    private Map<ConverterKey, Converter> converterMapping = new ConcurrentHashMap<ConverterKey, Converter>();

    @PostConstruct
    protected void initDefaultConverters() {
        this.addDefaultConverters();
        this.addCustomConverters();
    }

    public <S, T> Converter<S, T> create(Class<S> sourceType, Class<T> targetType, Class<? extends Annotation> metaDataType) {
        Converter result = this.converterMapping.get(new ConverterKey(sourceType, targetType, metaDataType));
        if (result != null) {
            return result;
        }
        return this.converterMapping.get(new ConverterKey(sourceType, targetType, null));
    }

    private void addDefaultConverters() {
        this.registerConverter(new StringToIntegerConverter());
        this.registerConverter(new StringToLongConverter());
    }

    private void addCustomConverters() {
        List<Converter> customConverters = this.getCustomConverters();
        for (Converter customConverter : customConverters) {
            this.registerConverter(customConverter);
        }
    }

    private List<Converter> getCustomConverters() {
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Set allBeans = beanManager.getBeans(Object.class, new Annotation[]{new AnyLiteral()});
        ArrayList<Bean> customConverterBeans = new ArrayList<Bean>();
        for (Bean currentBean : allBeans) {
            if (!Converter.class.isAssignableFrom(currentBean.getBeanClass()) || !this.isTypedAsConverter(currentBean)) continue;
            customConverterBeans.add(currentBean);
        }
        ArrayList<Converter> converters = new ArrayList<Converter>(customConverterBeans.size());
        for (Bean currentBean : customConverterBeans) {
            Converter currentConverter = (Converter)DefaultConverterFactory.getContextualReference(currentBean.getBeanClass(), beanManager, currentBean);
            converters.add(currentConverter);
        }
        return converters;
    }

    private static <T> T getContextualReference(Class<T> type, BeanManager beanManager, Bean<?> foundBean) {
        HashSet beanSet = new HashSet(1);
        beanSet.add(foundBean);
        Bean bean = beanManager.resolve(beanSet);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, type, creationalContext);
        return (T)result;
    }

    private boolean isTypedAsConverter(Bean<?> currentBean) {
        Set types = currentBean.getTypes();
        if (types == null) {
            return false;
        }
        for (Type currentType : types) {
            if (!(currentType instanceof Class) || !Converter.class.isAssignableFrom((Class)currentType)) continue;
            return true;
        }
        return false;
    }

    protected void registerConverter(Converter converter) {
        Class sourceType = null;
        Class targetType = null;
        Class metaDataType = null;
        for (Type currentType : converter.getClass().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(currentType instanceof ParameterizedType) || !Converter.class.isAssignableFrom((Class)(parameterizedType = (ParameterizedType)currentType).getRawType())) continue;
            sourceType = (Class)parameterizedType.getActualTypeArguments()[0];
            targetType = (Class)parameterizedType.getActualTypeArguments()[1];
            if (!MetaDataAwareConverter.class.isAssignableFrom((Class)parameterizedType.getRawType())) break;
            metaDataType = (Class)parameterizedType.getActualTypeArguments()[2];
            break;
        }
        this.converterMapping.put(new ConverterKey(sourceType, targetType, metaDataType), converter);
    }
}

