/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.util.HierarchyDiscovery;

public final class ExceptionHandlerComparator
implements Comparator<HandlerMethod<?>> {
    @Override
    public int compare(HandlerMethod<?> lhs, HandlerMethod<?> rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.getExceptionType().equals(rhs.getExceptionType())) {
            int returnValue = this.comparePrecedence(lhs.getOrdinal(), rhs.getOrdinal(), lhs.isBeforeHandler());
            if (returnValue == 0 && !lhs.getQualifiers().isEmpty()) {
                return -1;
            }
            return returnValue;
        }
        return this.compareHierarchies(lhs.getExceptionType(), rhs.getExceptionType());
    }

    private int compareHierarchies(Type lhsExceptionType, Type rhsExceptionType) {
        int indexOfRhsType;
        int indexOfLhsType;
        HierarchyDiscovery lhsHierarchy = new HierarchyDiscovery(lhsExceptionType);
        Set lhsTypeclosure = lhsHierarchy.getTypeClosure();
        if (lhsTypeclosure.contains(rhsExceptionType) && (indexOfLhsType = new ArrayList(lhsTypeclosure).indexOf(lhsExceptionType)) > (indexOfRhsType = new ArrayList(lhsTypeclosure).indexOf(rhsExceptionType))) {
            return 1;
        }
        return -1;
    }

    private int comparePrecedence(int lhs, int rhs, boolean isBefore) {
        if (!isBefore) {
            return lhs - rhs;
        }
        return (lhs - rhs) * -1;
    }
}

