/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.impl.exception.control.ExceptionHandlerComparator;
import org.apache.deltaspike.core.impl.exception.control.HandlerMethodStorage;
import org.apache.deltaspike.core.util.HierarchyDiscovery;

@Typed
class HandlerMethodStorageImpl
implements HandlerMethodStorage {
    private final Map<? super Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers;
    private Logger log = Logger.getLogger(HandlerMethodStorageImpl.class.toString());

    HandlerMethodStorageImpl(Map<? super Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers) {
        this.allHandlers = allHandlers;
    }

    @Override
    public <T extends Throwable> void registerHandlerMethod(HandlerMethod<T> handlerMethod) {
        this.log.fine(String.format("Adding handler %s to known handlers", handlerMethod));
        if (this.allHandlers.containsKey(handlerMethod.getExceptionType())) {
            this.allHandlers.get(handlerMethod.getExceptionType()).add(handlerMethod);
        } else {
            this.allHandlers.put(handlerMethod.getExceptionType(), new HashSet<HandlerMethod>(Arrays.asList(handlerMethod)));
        }
    }

    @Override
    public Collection<HandlerMethod<? extends Throwable>> getHandlersForException(Type exceptionClass, BeanManager bm, Set<Annotation> handlerQualifiers, boolean isBefore) {
        TreeSet<HandlerMethod<? extends Throwable>> returningHandlers = new TreeSet<HandlerMethod<? extends Throwable>>(new ExceptionHandlerComparator());
        HierarchyDiscovery h = new HierarchyDiscovery(exceptionClass);
        Set closure = h.getTypeClosure();
        for (Type hierarchyType : closure) {
            if (this.allHandlers.get(hierarchyType) == null) continue;
            for (HandlerMethod<? extends Throwable> handler : this.allHandlers.get(hierarchyType)) {
                if (handler.isBeforeHandler() && isBefore) {
                    if (handler.getQualifiers().contains(new AnyLiteral())) {
                        returningHandlers.add(handler);
                        continue;
                    }
                    if (handlerQualifiers.isEmpty() || !this.containsAny(handler.getQualifiers(), handlerQualifiers)) continue;
                    returningHandlers.add(handler);
                    continue;
                }
                if (handler.isBeforeHandler() || isBefore) continue;
                if (handler.getQualifiers().contains(new AnyLiteral())) {
                    returningHandlers.add(handler);
                    continue;
                }
                if (handlerQualifiers.isEmpty() || !this.containsAny(handler.getQualifiers(), handlerQualifiers)) continue;
                returningHandlers.add(handler);
            }
        }
        this.log.fine(String.format("Found handlers %s for exception type %s, qualifiers %s", returningHandlers, exceptionClass, handlerQualifiers));
        return Collections.unmodifiableCollection(returningHandlers);
    }

    private boolean containsAny(Collection<? extends Annotation> haystack, Collection<? extends Annotation> needles) {
        for (Annotation annotation : needles) {
            if (!haystack.contains(annotation)) continue;
            return true;
        }
        return false;
    }
}

