/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exception.control.extension;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.deltaspike.core.api.exception.control.HandlerMethod;
import org.apache.deltaspike.core.api.exception.control.annotation.ExceptionHandler;
import org.apache.deltaspike.core.impl.exception.control.HandlerMethodImpl;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class ExceptionControlExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ExceptionControlExtension.class.getName());
    private Map<? super Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers = new HashMap<Type, Collection<HandlerMethod<? extends Throwable>>>();
    private Boolean isActivated = null;

    protected void init(@Observes BeforeBeanDiscovery afterBeanDiscovery) {
        this.initActivation();
    }

    public <T> void findHandlers(@Observes ProcessBean<?> processBean, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (processBean.getBean() instanceof Interceptor || processBean.getBean() instanceof Decorator || !(processBean.getAnnotated() instanceof AnnotatedType)) {
            return;
        }
        AnnotatedType annotatedType = (AnnotatedType)processBean.getAnnotated();
        if (annotatedType.getJavaClass().isAnnotationPresent(ExceptionHandler.class)) {
            Set methods = annotatedType.getMethods();
            for (AnnotatedMethod method : methods) {
                if (!HandlerMethodImpl.isHandler(method)) continue;
                if (method.getJavaMember().getExceptionTypes().length != 0) {
                    processBean.addDefinitionError((Throwable)new IllegalArgumentException(String.format("Handler method %s must not throw exceptions", method.getJavaMember())));
                }
                this.registerHandlerMethod(new HandlerMethodImpl(method, beanManager));
            }
        }
    }

    public void verifyInjectionPoints(AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (Map.Entry<? super Type, Collection<HandlerMethod<? extends Throwable>>> entry : this.allHandlers.entrySet()) {
            for (HandlerMethod<? extends Throwable> handler : entry.getValue()) {
                for (InjectionPoint ip : ((HandlerMethodImpl)handler).getInjectionPoints()) {
                    try {
                        beanManager.validate(ip);
                    }
                    catch (InjectionException e) {
                        afterDeploymentValidation.addDeploymentProblem((Throwable)e);
                    }
                }
            }
        }
    }

    public Map<? super Type, Collection<HandlerMethod<? extends Throwable>>> getAllExceptionHandlers() {
        return Collections.unmodifiableMap(this.allHandlers);
    }

    private <T extends Throwable> void registerHandlerMethod(HandlerMethod<T> handlerMethod) {
        LOG.fine(String.format("Adding handler %s to known handlers", handlerMethod));
        if (this.allHandlers.containsKey(handlerMethod.getExceptionType())) {
            this.allHandlers.get(handlerMethod.getExceptionType()).add(handlerMethod);
        } else {
            this.allHandlers.put(handlerMethod.getExceptionType(), new HashSet<HandlerMethod>(Arrays.asList(handlerMethod)));
        }
    }

    public void initActivation() {
        if (this.isActivated == null) {
            this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        }
    }
}

