/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.impl.message.DefaultMessageContext;

@Typed
class DefaultMessage
implements Message {
    protected String messageTemplate;
    protected List<Object> arguments = new ArrayList<Object>();
    private MessageContext.Config messageContextConfig;

    DefaultMessage(MessageContext.Config messageContextConfig, String messageTemplate, Object ... arguments) {
        this.messageContextConfig = messageContextConfig;
        this.messageTemplate = messageTemplate;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public Message addArgument(Object ... arguments) {
        for (Object currentArgument : arguments) {
            Object argument = currentArgument;
            if (this.isHiddenArgument(argument)) {
                this.addHiddenArgument(argument);
                continue;
            }
            this.addArgumentToMessage(argument);
        }
        return this;
    }

    private void addArgumentToMessage(Object argument) {
        String result = argument instanceof String ? (String)argument : (argument == null ? "null" : argument.toString());
        this.addNumberedArgument((Serializable)((Object)result));
    }

    private boolean isHiddenArgument(Object argument) {
        return argument != null && argument.getClass().isArray();
    }

    private void addHiddenArgument(Object argument) {
        for (Object current : (Object[])argument) {
            this.addArgumentToMessage(current);
        }
    }

    protected void addNumberedArgument(Serializable argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Object>();
        }
        this.arguments.add(argument);
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    public String toString() {
        return this.toString(new DefaultMessageContext(this.messageContextConfig));
    }

    public String toString(MessageContext messageContext) {
        return messageContext.message().text(this.getMessageTemplate()).argument(this.getArguments()).toText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        if (!this.getMessageTemplate().equals(that.getMessageTemplate())) {
            return false;
        }
        return !(this.arguments != null ? !Arrays.equals(this.arguments.toArray(), that.getArguments()) : that.getArguments() != null);
    }

    public int hashCode() {
        int result = this.getMessageTemplate().hashCode();
        result = 31 * result + (this.arguments != null ? ((Object)this.arguments).hashCode() : 0);
        return result;
    }
}

