/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.impl.message.DefaultMessage;
import org.apache.deltaspike.core.impl.message.UnmodifiableMessageContext;

@Typed
class DefaultMessageBuilder
implements MessageContext.MessageBuilder {
    private String messageTemplate;
    private ArrayList<Object> argumentList;
    private final MessageContext messageContext;

    public DefaultMessageBuilder(MessageContext messageContext) {
        this.reset();
        this.messageContext = new UnmodifiableMessageContext(messageContext.config().use().create());
    }

    public MessageContext.MessageBuilder text(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    public MessageContext.MessageBuilder argument(Object ... arguments) {
        Collections.addAll(this.argumentList, arguments);
        return this;
    }

    private Message buildMessageTemplate() {
        if (this.messageTemplate == null) {
            throw new IllegalStateException("messageTemplate is missing");
        }
        return new DefaultMessage(this.messageContext.config(), this.messageTemplate, this.argumentList.toArray(new Object[this.argumentList.size()]));
    }

    protected void reset() {
        this.messageTemplate = null;
        this.argumentList = new ArrayList();
    }

    public Message create() {
        Message result = this.buildMessageTemplate();
        this.reset();
        return result;
    }

    public String toText() {
        Message baseMessage = this.buildMessageTemplate();
        return this.getMessageText(baseMessage);
    }

    private String getMessageText(Message baseMessage) {
        MessageInterpolator messageInterpolator;
        String messageTemplate = baseMessage.getMessageTemplate();
        MessageResolver messageResolver = this.messageContext.config().getMessageResolver();
        if (messageResolver != null) {
            messageTemplate = this.resolveMessage(messageResolver, baseMessage);
        }
        if ((messageInterpolator = this.messageContext.config().getMessageInterpolator()) != null && messageTemplate != null) {
            return this.checkedResult(this.interpolateMessage(messageInterpolator, messageTemplate, baseMessage.getArguments()), baseMessage);
        }
        return this.checkedResult(messageTemplate, baseMessage);
    }

    private String checkedResult(String result, Message baseMessage) {
        if (result == null || this.isKey(baseMessage.getMessageTemplate()) || this.isKeyWithoutMarkers(result, baseMessage)) {
            String oldTemplate = this.extractTemplate(baseMessage.getMessageTemplate());
            if (result == null || result.equals(oldTemplate)) {
                return "???" + oldTemplate + "???" + this.getArguments(baseMessage);
            }
        }
        return result;
    }

    private boolean isKeyWithoutMarkers(String result, Message baseMessage) {
        return !result.contains(" ") && result.endsWith(baseMessage.getMessageTemplate());
    }

    private String getArguments(Message message) {
        StringBuilder result = new StringBuilder();
        Object[] arguments = message.getArguments();
        if (arguments == null || arguments.length == 0) {
            return "";
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (i == 0) {
                result.append(" (");
            } else {
                result.append(",");
            }
            Object argument = arguments[i];
            result.append(argument.toString());
        }
        result.append(')');
        return result.toString();
    }

    private void resolveAndProcessLazyNumberedArgument(MessageContext messageContext, List<Object> result, String argument) {
        String resolvedArgumentValue = this.resolveValueOfArgumentDescriptor(messageContext, argument);
        result.add(resolvedArgumentValue);
    }

    private String resolveValueOfArgumentDescriptor(MessageContext messageContext, String argumentAsKey) {
        return messageContext.message().text(argumentAsKey).toText();
    }

    private String extractTemplate(String template) {
        String result = this.getEscapedTemplate(template);
        if (this.isKey(result)) {
            result = this.extractTemplateKey(result);
        }
        return result;
    }

    private boolean isKey(String key) {
        return key.startsWith("{") && key.endsWith("}");
    }

    private String extractTemplateKey(String key) {
        return key.substring(1, key.length() - 1);
    }

    private String resolveMessage(MessageResolver messageResolver, Message baseMessage) {
        return messageResolver.getMessage(baseMessage.getMessageTemplate());
    }

    private String interpolateMessage(MessageInterpolator messageInterpolator, String messageTemplate, Object ... arguments) {
        return messageInterpolator.interpolate(this.getEscapedTemplate(messageTemplate), arguments);
    }

    private String getEscapedTemplate(String messageTemplate) {
        if (messageTemplate.startsWith("\\{")) {
            return messageTemplate.substring(1);
        }
        return messageTemplate;
    }
}

