/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.impl.message.DefaultLocaleResolver;
import org.apache.deltaspike.core.impl.message.DefaultMessageContext;
import org.apache.deltaspike.core.impl.message.DefaultMessageInterpolator;

@Typed
class DefaultMessageContextConfig
implements MessageContext.Config {
    private static final long serialVersionUID = 2919944628020782545L;
    private MessageInterpolator messageInterpolator;
    private MessageResolver messageResolver;
    private LocaleResolver localeResolver;

    DefaultMessageContextConfig() {
        this.resetMessageContextConfig();
    }

    private DefaultMessageContextConfig(MessageContext.Config messageContextConfigTemplate) {
        this();
        this.messageInterpolator = messageContextConfigTemplate.getMessageInterpolator();
        this.messageResolver = messageContextConfigTemplate.getMessageResolver();
        this.localeResolver = messageContextConfigTemplate.getLocaleResolver();
    }

    public MessageContext.Config.MessageContextBuilder use() {
        return new MessageContext.Config.MessageContextBuilder(){
            private DefaultMessageContextConfig newMessageContextConfig;
            {
                this.newMessageContextConfig = new DefaultMessageContextConfig(DefaultMessageContextConfig.this);
            }

            public MessageContext.Config.MessageContextBuilder messageInterpolator(MessageInterpolator messageInterpolator) {
                this.newMessageContextConfig.setMessageInterpolator(messageInterpolator);
                return this;
            }

            public MessageContext.Config.MessageContextBuilder messageResolver(MessageResolver messageResolver) {
                this.newMessageContextConfig.setMessageResolver(messageResolver);
                return this;
            }

            public MessageContext.Config.MessageContextBuilder localeResolver(LocaleResolver localeResolver) {
                this.newMessageContextConfig.setLocaleResolver(localeResolver);
                return this;
            }

            public MessageContext create() {
                return new DefaultMessageContext(this.newMessageContextConfig);
            }
        };
    }

    public MessageContext.Config.MessageContextBuilder change() {
        return new MessageContext.Config.MessageContextBuilder(){

            public MessageContext.Config.MessageContextBuilder messageInterpolator(MessageInterpolator messageInterpolator) {
                DefaultMessageContextConfig.this.setMessageInterpolator(messageInterpolator);
                return this;
            }

            public MessageContext.Config.MessageContextBuilder messageResolver(MessageResolver messageResolver) {
                DefaultMessageContextConfig.this.setMessageResolver(messageResolver);
                return this;
            }

            public MessageContext.Config.MessageContextBuilder localeResolver(LocaleResolver localeResolver) {
                DefaultMessageContextConfig.this.setLocaleResolver(localeResolver);
                return this;
            }

            public MessageContext create() {
                return new DefaultMessageContext(DefaultMessageContextConfig.this);
            }
        };
    }

    private void resetMessageContextConfig() {
        this.messageInterpolator = new DefaultMessageInterpolator();
        this.messageResolver = null;
        this.localeResolver = new DefaultLocaleResolver();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    private void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    private void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    private void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder configInfo = new StringBuilder("MessageContextConfig class: ");
        configInfo.append(this.getClass().getName());
        configInfo.append(newLine);
        if (this.messageInterpolator != null) {
            configInfo.append("   MessageInterpolator class: ").append(this.messageInterpolator.getClass());
        } else {
            configInfo.append("   no MessageInterpolator");
        }
        configInfo.append(newLine);
        if (this.messageResolver != null) {
            configInfo.append("   MessageResolver class: ").append(this.messageResolver.getClass());
        } else {
            configInfo.append("   no MessageResolver");
        }
        configInfo.append(newLine);
        configInfo.append(newLine);
        if (this.localeResolver != null) {
            configInfo.append("   LocaleResolver class: ").append(this.localeResolver.getClass());
        } else {
            configInfo.append("   no LocaleResolver");
        }
        configInfo.append(newLine);
        return configInfo.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMessageContextConfig)) {
            return false;
        }
        DefaultMessageContextConfig that = (DefaultMessageContextConfig)o;
        if (!this.localeResolver.equals(that.localeResolver)) {
            return false;
        }
        if (this.messageInterpolator != null ? !this.messageInterpolator.equals(that.messageInterpolator) : that.messageInterpolator != null) {
            return false;
        }
        return !(this.messageResolver != null ? !this.messageResolver.equals(that.messageResolver) : that.messageResolver != null);
    }

    public int hashCode() {
        int result = this.messageInterpolator != null ? this.messageInterpolator.hashCode() : 0;
        result = 31 * result + (this.messageResolver != null ? this.messageResolver.hashCode() : 0);
        result = 31 * result + this.localeResolver.hashCode();
        return result;
    }
}

