/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.util.PropertyFileUtils;

@Typed
class DefaultMessageResolver
implements MessageResolver {
    private static final long serialVersionUID = 5834411208472341006L;
    private final ResourceBundle messageBundle;

    DefaultMessageResolver(String messageBundleName, Locale locale) {
        ResourceBundle resolvedBundle;
        try {
            resolvedBundle = PropertyFileUtils.getResourceBundle((String)messageBundleName, (Locale)locale);
        }
        catch (MissingResourceException e) {
            resolvedBundle = null;
        }
        this.messageBundle = resolvedBundle;
    }

    public String getMessage(String messageTemplate) {
        if (this.messageBundle != null && messageTemplate != null && messageTemplate.startsWith("{") && messageTemplate.endsWith("}")) {
            try {
                return this.messageBundle.getString(messageTemplate.substring(1, messageTemplate.length() - 1));
            }
            catch (MissingResourceException e) {
                return "???" + messageTemplate + "???";
            }
        }
        return messageTemplate;
    }
}

