/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.annotation.MessageBundle;
import org.apache.deltaspike.core.api.message.annotation.MessageTemplate;
import org.apache.deltaspike.core.impl.message.NarrowingBeanBuilder;
import org.apache.deltaspike.core.impl.message.TypedMessageBundle;
import org.apache.deltaspike.core.impl.message.TypedMessageBundleProducer;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class MessageBundleExtension
implements Extension,
Deactivatable {
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> bundleProducerBean;
    private Boolean isActivated = null;

    protected void init(@Observes BeforeBeanDiscovery afterBeanDiscovery) {
        this.initActivation();
    }

    protected void detectInterfaces(@Observes ProcessAnnotatedType<?> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(MessageBundle.class)) {
            this.validateMessageBundle(type.getJavaClass());
            this.messageBundleTypes.add(type);
        }
    }

    private void validateMessageBundle(Class<?> currentClass) {
        for (Method currentMethod : currentClass.getDeclaredMethods()) {
            if (!currentMethod.isAnnotationPresent(MessageTemplate.class) || String.class.isAssignableFrom(currentMethod.getReturnType())) continue;
            if (Message.class.isAssignableFrom(currentMethod.getReturnType())) {
                this.validateMessageContextAwareMethod(currentMethod);
                continue;
            }
            throw new IllegalStateException(currentMethod.getReturnType().getName() + " isn't supported. Details: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + " only " + String.class.getName() + " or " + Message.class.getName());
        }
    }

    private void validateMessageContextAwareMethod(Method currentMethod) {
        for (Class<?> currentParameterType : currentMethod.getParameterTypes()) {
            if (!MessageContext.class.isAssignableFrom(currentParameterType)) continue;
            return;
        }
        throw new IllegalStateException("No " + MessageContext.class.getName() + " parameter found at: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + ". That is required for return-type " + Message.class.getName());
    }

    protected void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageBundleProducer> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    protected void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageBundleProducer, Object> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    protected void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (method.isAnnotationPresent(TypedMessageBundle.class)) {
            this.bundleProducerBean = bean;
        }
    }

    protected void installMessageBundleProducerBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            event.addBean(MessageBundleExtension.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
        }
    }

    private static <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> annotatedType, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager).readFromType(annotatedType).types(new Type[]{annotatedType.getJavaClass(), Object.class}).create();
    }

    protected void cleanup(@Observes AfterDeploymentValidation event) {
        this.messageBundleTypes.clear();
    }

    protected void initActivation() {
        if (this.isActivated == null) {
            this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        }
    }
}

