/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.deltaspike.core.api.literal.MessageContextConfigLiteral;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.api.message.annotation.MessageContextConfig;
import org.apache.deltaspike.core.api.message.annotation.MessageTemplate;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.message.DefaultMessageResolver;
import org.apache.deltaspike.core.util.ClassUtils;

class MessageBundleInvocationHandler
implements InvocationHandler {
    MessageBundleInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MessageTemplate messageTemplate = method.getAnnotation(MessageTemplate.class);
        if (messageTemplate == null) {
            return null;
        }
        MessageContext messageContext = null;
        ArrayList<Object> arguments = null;
        if (args != null && args.length > 0) {
            arguments = new ArrayList<Object>(args.length);
            for (Object arg : args) {
                if (MessageContext.class.isAssignableFrom(arg.getClass())) {
                    messageContext = (MessageContext)arg;
                    continue;
                }
                arguments.add(arg);
            }
        }
        if (messageContext == null) {
            String resolvedMessageTemplate;
            MessageContextConfig messageContextConfig = method.getDeclaringClass().getAnnotation(MessageContextConfig.class);
            if (messageContextConfig == null) {
                messageContextConfig = new MessageContextConfigLiteral();
            }
            if (!MessageResolver.class.equals((Object)messageContextConfig.messageResolver())) {
                Class messageResolverClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.messageResolver().getName());
                MessageResolver messageResolver = (MessageResolver)BeanProvider.getContextualReference((Class)messageResolverClass, (Annotation[])new Annotation[0]);
                resolvedMessageTemplate = messageResolver.getMessage(messageTemplate.value());
            } else {
                Class localeResolverClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.localeResolver().getName());
                Locale resolvedLocale = Locale.getDefault();
                if (!LocaleResolver.class.equals((Object)localeResolverClass)) {
                    LocaleResolver localeResolver = (LocaleResolver)BeanProvider.getContextualReference((Class)localeResolverClass, (Annotation[])new Annotation[0]);
                    resolvedLocale = localeResolver.getLocale();
                }
                String messageBundleName = method.getDeclaringClass().getName();
                resolvedMessageTemplate = new DefaultMessageResolver(messageBundleName, resolvedLocale).getMessage(messageTemplate.value());
            }
            Class messageInterpolatorClass = ClassUtils.tryToLoadClassForName((String)messageContextConfig.messageInterpolator().getName());
            String result = resolvedMessageTemplate;
            if (!MessageInterpolator.class.equals((Object)messageInterpolatorClass)) {
                MessageInterpolator messageInterpolator = (MessageInterpolator)BeanProvider.getContextualReference((Class)messageInterpolatorClass, (Annotation[])new Annotation[0]);
                result = messageInterpolator.interpolate(resolvedMessageTemplate, args);
            }
            return result;
        }
        if (String.class.isAssignableFrom(method.getReturnType())) {
            return messageContext.message().text(messageTemplate.value()).argument(arguments.toArray()).toText();
        }
        return messageContext.message().text(messageTemplate.value()).argument(arguments.toArray()).create();
    }
}

