/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.message;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.message.LocaleResolver;
import org.apache.deltaspike.core.api.message.MessageContext;
import org.apache.deltaspike.core.api.message.MessageInterpolator;
import org.apache.deltaspike.core.api.message.MessageResolver;
import org.apache.deltaspike.core.impl.message.DefaultMessageContext;

@ApplicationScoped
public class MessageContextProducer {
    @Produces
    @Typed(value={MessageContext.class})
    @Dependent
    protected MessageContext createDefaultMessageContext(Instance<MessageResolver> customMessageResolver, Instance<MessageInterpolator> customMessageInterpolator, Instance<LocaleResolver> customLocalResolver) {
        MessageContext.Config messageContextConfig = new DefaultMessageContext().config();
        if (!customMessageResolver.isUnsatisfied()) {
            messageContextConfig.change().messageResolver((MessageResolver)customMessageResolver.get());
        }
        if (!customMessageInterpolator.isUnsatisfied()) {
            messageContextConfig.change().messageInterpolator((MessageInterpolator)customMessageInterpolator.get());
        }
        if (!customLocalResolver.isUnsatisfied()) {
            messageContextConfig.change().localeResolver((LocaleResolver)customLocalResolver.get());
        }
        return messageContextConfig.use().create();
    }
}

